% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtrendline.R
\name{ggtrendline}
\alias{ggtrendline}
\title{Add Trendline and Confidence Interval to 'ggplot'}
\usage{
ggtrendline(
  x,
  y,
  model = "line2P",
  linecolor = "black",
  linetype = 1,
  linewidth = 0.6,
  CI.level = 0.95,
  CI.fill = "grey60",
  CI.alpha = 0.3,
  CI.color = "black",
  CI.lty = 2,
  CI.lwd = 0.5,
  summary = TRUE,
  show.eq = TRUE,
  yhat = FALSE,
  eq.x = NULL,
  eq.y = NULL,
  show.Rsquare = TRUE,
  show.pvalue = TRUE,
  Pvalue.corrected = TRUE,
  Rname = 0,
  Pname = 0,
  rrp.x = NULL,
  rrp.y = NULL,
  text.col = "black",
  eDigit = 3,
  eSize = 3,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the 'ggplot'. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{linecolor}{the color of regression line. Default is "black".}

\item{linetype}{the type of regression line.  Default is 1. Notes: linetype can be specified using either text c("blank","solid","dashed","dotted","dotdash","longdash","twodash") or number c(0, 1, 2, 3, 4, 5, 6).}

\item{linewidth}{the width of regression line. Default is 0.6.}

\item{CI.level}{level of confidence interval to use. Default is 0.95.}

\item{CI.fill}{the color for filling the confidence interval. Default is "grey60".}

\item{CI.alpha}{alpha value of filling color of confidence interval. Default is 0.3.}

\item{CI.color}{line color of confidence interval. Default is "black".}

\item{CI.lty}{line type of confidence interval. Default is 2.}

\item{CI.lwd}{line width of confidence interval. Default is 0.5.}

\item{summary}{summarizing the model fits. Default is TRUE.}

\item{show.eq}{whether to show the regression equation, the value is one of c("TRUE", "FALSE").}

\item{yhat}{whether to add a hat symbol (^) on the top of "y" in equation. Default is FALSE.}

\item{eq.x, eq.y}{equation position.}

\item{show.Rsquare}{whether to show the R-square, the value is one of c("TRUE", "FALSE").}

\item{show.pvalue}{whether to show the P-value, the value is one of c("TRUE", "FALSE").}

\item{Pvalue.corrected}{if P-value corrected or not, the value is one of c("TRUE", "FALSE").}

\item{Rname}{to specify the character of R-square, the value is one of c(0, 1), corresponding to c(r^2, R^2).}

\item{Pname}{to specify the character of P-value, the value is one of c(0, 1), corresponding to c(p, P).}

\item{rrp.x, rrp.y}{the position for R square and P value.}

\item{text.col}{the color used for the equation text.}

\item{eDigit}{the numbers of digits for R square and P value. Default is 3.}

\item{eSize}{font size of R square and P value. Default is 3.}

\item{xlab, ylab}{labels of x- and y-axis.}
}
\value{
No return value (called for side effects).
}
\description{
Add trendline and confidence interval of linear or nonlinear regression model to 'ggplot',
by using different models built in the 'ggtrendline()' function. \cr The function includes the following models:\cr
"line2P" (formula as: y=a*x+b), \cr  "line3P" (y=a*x^2+b*x+c), \cr "log2P" (y=a*ln(x)+b), \cr "exp2P" (y=a*exp(b*x)), \cr  "exp3P" (y=a*exp(b*x)+c), \cr "power2P" (y=a*x^b), \cr and "power3P" (y=a*x^b+c).
}
\details{
The values of each parameter of regression model can be found by typing \code{\link{trendline_sum}} function in this package.\cr\cr The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).
}
\examples{
# library(ggplot2)
library(ggtrendline)
x <- c(1, 3, 6, 9,  13,   17)
y <- c(5, 8, 11, 13, 13.2, 13.5)

ggtrendline(x, y, model = "line2P")  # default
ggtrendline(x, y, model = "log2P", CI.fill = NA)  # CI lines only, without CI filling

ggtrendline(x, y, model = "exp2P", linecolor = "blue", linetype = 1, linewidth = 1) # set line
ggtrendline(x, y, model = "exp3P", CI.level = 0.99,
            CI.fill = "red", CI.alpha = 0.1, CI.color = NA, CI.lty = 2, CI.lwd = 1.5) # set CI

}
\references{
Ritz C., and Streibig J. C. (2007)
\emph{Nonlinear Regression with R}. Springer.

Greenwell B. M., and Schubert Kabban C. M. (2014)
\emph{investr: An R Package for Inverse Estimation}. The R Journal, 6(1), 90-100.
}
\seealso{
\code{\link{ggtrendline}}, \code{\link{stat_eq}}, \code{\link{stat_rrp}}, \code{\link{trendline_sum}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
