% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtaxplot.R
\name{ggtaxplot}
\alias{ggtaxplot}
\title{ggtaxplot Process and Plot Taxonomic Data}
\usage{
ggtaxplot(
  data,
  ID_col = "ID",
  tax_col = "Taxonomy",
  rm_NA = FALSE,
  threshold = 2,
  custom_colors = NULL
)
}
\arguments{
\item{data}{A data frame containing two columns: ID and Taxonomy.}

\item{ID_col}{A column with ID values.}

\item{tax_col}{A column with Taxonomy.}

\item{rm_NA}{A logical value indicating whether to remove rows where the taxonomy column is 'Unknown' or NA. Default is FALSE.}

\item{threshold}{A numeric threshold for filtering low-abundance taxa (Others).}

\item{custom_colors}{Optional custom colors assigned to phyla.}
}
\value{
A ggplot object of the river plot.
}
\description{
This function processes data and generates a taxonomic river plot.
}
\examples{
# Example data frame
data <- data.frame(
 ID = c("ID1", "ID2", "ID3"),
 Taxonomy = c("d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;\
 o__Enterobacterales;f__Enterobacteriaceae;g__Escherichia",
            "d__Bacteria;p__Actinobacteria;c__Actinobacteria;\
            o__Corynebacteriales;f__Corynebacteriaceae;g__Corynebacterium",
            "d__Bacteria;p__Firmicutes;c__Bacilli;\
            o__Bacillales;f__Bacillaceae;g__Bacillus")
            )
# Generate the river plot
plot <- ggtaxplot(data)
print(plot)
}
