% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{animate_density}
\alias{animate_density}
\title{An animated density of a single variable across targets.}
\usage{
animate_density(
  output,
  parameter,
  dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  mcmc = FALSE,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE,
  duration = NULL,
  animate_plot = TRUE,
  save_filename = NULL,
  save_path = NULL
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameter}{The parameter for which we wish to view the density.}

\item{dimension}{(optional) The dimension of the parameter for which we wish to view the density. (default is 1)}

\item{target}{(optiona) If specified, will fix to this target, and animate over ExternalTarget (if present in output).}

\item{external_target}{(optional) If specified, will fix to this external_target, and animate over Target.}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the density. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{mcmc}{(optional) If TRUE, the user is indicating that the output is from an MCMC algorithm. This will set use_initial_points=FALSE and use_weights=FALSE no matter what the user sets these arguments to. (default is FALSE)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}

\item{duration}{(optional) The duration of the animation. (defaults to producing an animation that uses 10 frames per second)}

\item{animate_plot}{(optional) If TRUE, will return an animation. If FALSE, returns a gganim object that can be further modified before animating. (defaults to FALSE)}

\item{save_filename}{(optional) If specified, the animation will be saved to a gif with this filename. (default is not to save)}

\item{save_path}{(optional) If specified along with save_filename, will save the gif to save_path/save_filename. (defaults to working directory)}
}
\value{
An animated density
}
\description{
An animated density of a single variable across targets.
}
