% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlases.R
\name{aseg}
\alias{aseg}
\title{FreeSurfer Automatic Subcortical Segmentation Atlas}
\usage{
aseg()
}
\value{
A \code{ggseg_atlas} object with components:
\describe{
\item{atlas}{Character. Atlas name ("aseg")}
\item{type}{Character. Atlas type ("subcortical")}
\item{palette}{Named character vector of colours for each region}
\item{data}{A \code{ggseg_data_subcortical} object containing:
\describe{
\item{meshes}{Data frame with \code{label} and \code{mesh} columns}
\item{sf}{Simple features data frame for 2D rendering}
}
}
}
}
\description{
Returns the FreeSurfer automatic subcortical segmentation (aseg) atlas
containing deep brain structures including the thalamus, caudate, putamen,
pallidum, hippocampus, amygdala, accumbens, and ventricles.
}
\details{
This atlas is derived from FreeSurfer's \code{aseg.mgz} volumetric segmentation.
It works with both ggseg (2D slice views) and ggseg3d (3D mesh
visualizations) from a single object.
}
\section{Structures}{

The atlas contains bilateral structures:
\itemize{
\item Thalamus
\item Caudate
\item Putamen
\item Pallidum (globus pallidus)
\item Hippocampus
\item Amygdala
\item Accumbens (nucleus accumbens)
\item Ventral diencephalon
}

Plus midline and ventricular structures:
\itemize{
\item Lateral ventricles
\item Third ventricle
\item Fourth ventricle
\item Brain stem
\item Cerebellar cortex
\item Cerebellar white matter
}
}

\examples{
aseg()

atlas_regions(aseg())
}
\references{
Fischl B, Salat DH, Busa E, et al. (2002).
Whole brain segmentation: automated labeling of neuroanatomical
structures in the human brain.
Neuron, 33(3):341-355.
\doi{10.1016/S0896-6273(02)00569-X}
}
\seealso{
\code{\link[=dk]{dk()}} for cortical parcellation,
\code{\link[=ggseg_atlas]{ggseg_atlas()}} for the atlas class constructor

Other ggseg_atlases: 
\code{\link{dk}()},
\code{\link{tracula}()}
}
\concept{ggseg_atlases}
