% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R, R/nn_model.R
\name{ggml_fit.ggml_functional_model}
\alias{ggml_fit.ggml_functional_model}
\alias{ggml_fit}
\alias{ggml_fit.ggml_sequential_model}
\alias{ggml_fit.default}
\title{Train a Model (dispatcher)}
\usage{
\method{ggml_fit}{ggml_functional_model}(
  model,
  x,
  y,
  epochs = 1L,
  batch_size = 32L,
  validation_split = 0,
  validation_data = NULL,
  verbose = 1L,
  ...
)

ggml_fit(model, ...)

\method{ggml_fit}{ggml_sequential_model}(model, ...)

\method{ggml_fit}{default}(model, ...)
}
\arguments{
\item{model}{A compiled model object.}

\item{x}{Training data (matrix or array).}

\item{y}{Training labels (matrix, one-hot encoded).}

\item{epochs}{Number of training epochs (default: 1).}

\item{batch_size}{Batch size (default: 32).}

\item{validation_split}{Fraction of data for validation (default: 0).}

\item{validation_data}{Optional list(x_val, y_val). Overrides validation_split.}

\item{verbose}{0 = silent, 1 = progress (default: 1).}

\item{...}{Arguments passed to the appropriate implementation.}
}
\value{
For Sequential models: the trained model (invisibly).
  For the low-level API: a data frame with columns
  \code{epoch}, \code{train_loss}, \code{train_accuracy},
  \code{val_loss}, \code{val_accuracy}.
}
\description{
Dispatcher: if the first argument is a \code{ggml_sequential_model}, delegates
to the Keras-style high-level API (\code{ggml_fit_sequential}); otherwise
delegates to the low-level optimizer loop (\code{ggml_fit_opt}).
}
\details{
\strong{Keras-style (Sequential model):}
\describe{
  \item{model}{A compiled \code{ggml_sequential_model}}
  \item{x}{Training data (matrix or array)}
  \item{y}{Training labels (matrix, one-hot encoded for classification)}
  \item{epochs}{Number of training epochs (default: 1)}
  \item{batch_size}{Batch size (default: 32)}
  \item{validation_split}{Fraction of data for validation (default: 0)}
  \item{validation_data}{Optional list(x_val, y_val) for validation. Overrides validation_split.}
  \item{class_weight}{Named vector of weights per class, e.g. c("0"=1, "1"=10). Cannot be used with sample_weight.}
  \item{sample_weight}{Numeric vector of per-sample weights (length = nrow(x)). Cannot be used with class_weight.}
  \item{verbose}{0 = silent, 1 = progress (default: 1)}
}

\strong{Low-level (optimizer loop):}
\describe{
  \item{sched}{Backend scheduler}
  \item{ctx_compute}{Compute context}
  \item{inputs}{Input tensor}
  \item{outputs}{Output tensor}
  \item{dataset}{Dataset from \code{ggml_opt_dataset_init()}}
  \item{loss_type}{Loss type (default: MSE)}
  \item{optimizer}{Optimizer type (default: AdamW)}
  \item{nepoch}{Number of epochs (default: 10)}
  \item{nbatch_logical}{Logical batch size (default: 32)}
  \item{val_split}{Validation fraction (default: 0)}
  \item{callbacks}{List of callback objects}
  \item{silent}{Suppress output (default: FALSE)}
}
}
\examples{
\donttest{
n <- 128
x <- matrix(runif(n * 4), nrow = n, ncol = 4)
y <- matrix(0, nrow = n, ncol = 2)
for (i in seq_len(n)) { y[i, if (sum(x[i,]) > 2) 1L else 2L] <- 1 }

model <- ggml_model_sequential() |>
  ggml_layer_dense(8, activation = "relu") |>
  ggml_layer_dense(2, activation = "softmax")
model$input_shape <- 4L
model <- ggml_compile(model, optimizer = "adam",
                      loss = "categorical_crossentropy")

# Basic training
model <- ggml_fit(model, x, y, epochs = 5, batch_size = 32, verbose = 0)

# With validation_data
x_val <- matrix(runif(32 * 4), nrow = 32, ncol = 4)
y_val <- matrix(0, nrow = 32, ncol = 2)
for (i in seq_len(32)) { y_val[i, if (sum(x_val[i,]) > 2) 1L else 2L] <- 1 }
model <- ggml_fit(model, x, y, epochs = 3, batch_size = 32,
                  validation_data = list(x_val, y_val), verbose = 0)

# With class_weight (useful for imbalanced classes)
model <- ggml_fit(model, x, y, epochs = 3, batch_size = 32,
                  class_weight = c("0" = 1, "1" = 2), verbose = 0)

# With sample_weight
sw <- runif(n, 0.5, 1.5)
model <- ggml_fit(model, x, y, epochs = 3, batch_size = 32,
                  sample_weight = sw, verbose = 0)
}
}
\seealso{
\code{\link{ggml_fit_opt}}, \code{\link{ggml_compile}}
}
