% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{ggml_callback_early_stopping}
\alias{ggml_callback_early_stopping}
\title{Early stopping callback}
\usage{
ggml_callback_early_stopping(
  monitor = "val_loss",
  patience = 5,
  min_delta = 0,
  mode = "auto"
)
}
\arguments{
\item{monitor}{Metric to monitor: "val_loss", "val_accuracy", "train_loss", "train_accuracy"}

\item{patience}{Number of epochs with no improvement before stopping}

\item{min_delta}{Minimum change to qualify as improvement}

\item{mode}{"min" (lower is better) or "max" (higher is better). "auto" infers from monitor name.}
}
\value{
List with on_epoch_end function
}
\description{
Stops training when the monitored metric does not improve.
}
\seealso{
Other callbacks: 
\code{\link{ggml_schedule_cosine_decay}()},
\code{\link{ggml_schedule_reduce_on_plateau}()},
\code{\link{ggml_schedule_step_decay}()}
}
\concept{callbacks}
