% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_training.R
\name{ag_dataloader}
\alias{ag_dataloader}
\title{Create a mini-batch data loader}
\usage{
ag_dataloader(x, y = NULL, batch_size = 32L, shuffle = TRUE, col_major = TRUE)
}
\arguments{
\item{x}{Feature matrix \code{[features, n_samples]} or
\code{[n_samples, features]} — see \code{col_major}.}

\item{y}{Label matrix with the same convention.}

\item{batch_size}{Integer batch size.}

\item{shuffle}{Logical; if \code{TRUE} (default) shuffle at each \code{reset()}.}

\item{col_major}{Logical; if \code{TRUE} (default) \code{x} and \code{y} are
already \code{[features, n]} (ggml/ag convention).  Set \code{FALSE} for
row-major \code{[n, features]} (R/Keras convention) — they will be
transposed automatically.}
}
\value{
An \code{ag_dataloader} environment
}
\description{
Returns an iterator environment.  Each call to \code{$next_batch()} returns
a named list \code{list(x, y)} with ag_tensor objects of shape
\code{[features, batch_size]} / \code{[labels, batch_size]}.
After the last batch, \code{$has_next()} returns \code{FALSE}; call
\code{$reset()} (or start a new epoch via \code{$epoch()}) to reshuffle
and restart.
}
\examples{
\donttest{
n  <- 128L
x  <- matrix(runif(4 * n), 4, n)   # [4, 128] col-major
y  <- matrix(runif(2 * n), 2, n)
dl <- ag_dataloader(x, y, batch_size = 32L)
dl$reset()
while (dl$has_next()) {
  batch <- dl$next_batch()
  # batch$x: [4, 32],  batch$y: [2, 32]
}
}
}
