% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_codonw.R
\name{read_codonw}
\alias{read_codonw}
\title{Process .blk files from CodonW}
\usage{
read_codonw(folder_path)
}
\arguments{
\item{folder_path}{The path to the folder containing .blk files to process.}
}
\value{
A combined data frame of all processed .blk files with columns:
  \item{AA}{Amino acid abbreviation}
  \item{Codon}{DNA codon sequence}
  \item{RSCU}{Relative Synonymous Codon Usage value}
  \item{Fill}{Position index within amino acid group}
  \item{Species}{Species name derived from file name}
}
\description{
This function processes .blk files from the CodonW software.
It reads the files, cleans the data, and returns a combined data frame.
}
\examples{
# Using example data
example_dir <- system.file("extdata", "codonw", package = "ggmRSCU")
result <- read_codonw(example_dir)
head(result)

}
