% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_ineq.R
\name{annotate_ineq}
\alias{annotate_ineq}
\title{Annotate ggplot2 chart with inequality metric}
\usage{
annotate_ineq(
  data_ineq,
  x = 0.1,
  y = 0.95,
  decimals = 2,
  measure_ineq = "Gini",
  sep_ineq = ": ",
  ...
)
}
\arguments{
\item{data_ineq}{Data to calculate the inequality metric on.}

\item{x}{annotation x-axis position, defaults to 0.1.}

\item{y}{annotation y-axis position, defaults to 0.95.}

\item{decimals}{number of decimals to show, defaults to 2.}

\item{measure_ineq}{Name of measure to use; defaults to Gini.}

\item{sep_ineq}{text separator between annotation label and value.}

\item{...}{any additional parameters to ggplot2::annotate().}
}
\description{
Adds text annotation to chart with any inequality measure from ineq::ineq
Inequality measures include Gini, RS, Atkinson, Theil, Kol, var, square.var, entropy
}
\examples{
library(gglorenz)

ggplot(billionaires, aes(TNW)) +
    stat_lorenz() +
    annotate_ineq(billionaires$TNW)

ggplot(billionaires, aes(TNW)) +
    stat_lorenz(desc = TRUE) +
    geom_abline(linetype = "dashed") +
    theme_bw() +
    annotate_ineq(billionaires$TNW, measure_ineq = "RS", color = "red",
                  family = theme_get()$text[["family"]],
                  size = theme_get()$text[["size"]] / 2,
                  fontface = "italic")

}
\references{
\href{https://en.wikipedia.org/wiki/Gini_coefficient}{Gini coefficient from Wikipedia}
}
