% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_bins_interactive.R
\name{guide_bins_interactive}
\alias{guide_bins_interactive}
\title{Create interactive bins guide}
\usage{
guide_bins_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function.}
}
\value{
An interactive guide object.
}
\description{
The guide is based on \code{\link[ggplot2:guide_bins]{ggplot2::guide_bins()}}.
See the documentation for that function for more details.
}
\section{Details for interactive scale and interactive guide functions}{

For scales, the interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors, depending on the number of breaks (levels) and
the type of the guide used.
The guides do not accept any interactive parameter directly, they receive them from the scales.

When guide of type \code{legend}, \code{bins}, \code{colourbar} or \code{coloursteps} is used,
it will be converted to a \code{\link[=guide_legend_interactive]{guide_legend_interactive()}}, \code{\link[=guide_bins_interactive]{guide_bins_interactive()}},
\code{\link[=guide_colourbar_interactive]{guide_colourbar_interactive()}} or \code{\link[=guide_coloursteps_interactive]{guide_coloursteps_interactive()}} respectively,
if it's not already.

The length of each scale interactive parameter vector should match the length of the breaks.
It can also be a named vector, where each name should correspond to the same break name.
It can also be defined as function that takes the breaks as input and returns a named or
unnamed vector of values as output.

For binned guides like \code{bins} and \code{coloursteps} the breaks include the label breaks and the limits.
The number of bins will be one less than the number of breaks and the interactive parameters can be
constructed for each bin separately (look at the examples).
For \code{colourbar} guide in raster mode, the breaks vector, is scalar 1 always, meaning the interactive
parameters should be scalar too. For \code{colourbar} guide in non-raster mode, the bar is drawn using
rectangles, and the breaks are the midpoints of each rectangle.

The interactive parameters here, give interactivity only to the key elements of the guide.

To provide interactivity to the rest of the elements of a guide, (title, labels, background, etc),
the relevant theme elements or relevant guide arguments can be used.
The \code{guide} arguments \code{title.theme} and \code{label.theme} can be defined as
\code{element_text_interactive} (in fact, they will be converted to that if they are not
already), either directly or via the theme.
See the element_*_interactive section for more details.
}

\examples{
# add interactive bins guide to a ggplot -------
library(ggplot2)
library(ggiraph)

set.seed(4393)
dsmall <- diamonds[sample(nrow(diamonds), 1000), ]
p <- ggplot(dsmall, aes(x, y)) +
  stat_density_2d(
    aes(
      fill = after_stat(nlevel),
      tooltip = paste("nlevel:", after_stat(nlevel))
    ),
    geom = "interactive_polygon"
  ) +
  facet_grid(. ~ cut)

# add interactive binned scale and guide
p1 <- p +
  scale_fill_viridis_b_interactive(
    data_id = "nlevel",
    tooltip = "nlevel",
    guide = "bins"
  )
x <- girafe(ggobj = p1)

\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
x

# set the keys separately
p2 <- p +
  scale_fill_viridis_b_interactive(
    data_id = function(breaks) {
      sapply(seq_along(breaks), function(i) {
        if (i < length(breaks)) {
          paste(
            min(breaks[i], breaks[i + 1], na.rm = TRUE),
            max(breaks[i], breaks[i + 1], na.rm = TRUE),
            sep = "-"
          )
        } else {
          NA_character_
        }
      })
    },
    tooltip = function(breaks) {
      sapply(seq_along(breaks), function(i) {
        if (i < length(breaks)) {
          paste(
            min(breaks[i], breaks[i + 1], na.rm = TRUE),
            max(breaks[i], breaks[i + 1], na.rm = TRUE),
            sep = "-"
          )
        } else {
          NA_character_
        }
      })
    },
    guide = "bins"
  )
x <- girafe(ggobj = p2)
x

# make the title and labels interactive
p3 <- p +
  scale_fill_viridis_c_interactive(
    data_id = function(breaks) {
      sapply(seq_along(breaks), function(i) {
        if (i < length(breaks)) {
          paste(
            min(breaks[i], breaks[i + 1], na.rm = TRUE),
            max(breaks[i], breaks[i + 1], na.rm = TRUE),
            sep = "-"
          )
        } else {
          NA_character_
        }
      })
    },
    tooltip = function(breaks) {
      sapply(seq_along(breaks), function(i) {
        if (i < length(breaks)) {
          paste(
            min(breaks[i], breaks[i + 1], na.rm = TRUE),
            max(breaks[i], breaks[i + 1], na.rm = TRUE),
            sep = "-"
          )
        } else {
          NA_character_
        }
      })
    },
    guide = "bins",
    name = label_interactive("nlevel", data_id = "nlevel", tooltip = "nlevel"),
    labels = function(breaks) {
      label_interactive(
        as.character(breaks),
        data_id = as.character(breaks),
        onclick = paste0("alert(\"", as.character(breaks), "\")"),
        tooltip = as.character(breaks)
      )
    }
  )
x <- girafe(ggobj = p3)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
x
\dontshow{\}) # examplesIf}
}
\seealso{
\link{interactive_parameters}, \code{\link[=girafe]{girafe()}}
}
