% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{read_vcf}
\alias{read_vcf}
\title{Read a VCF file}
\usage{
read_vcf(
  file,
  parse_info = FALSE,
  col_names = def_names("vcf"),
  col_types = def_types("vcf")
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector). \code{file} can also be a character vector
containing multiple filepaths or a list containing multiple connections.

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will be automatically
decompressed. Files starting with \verb{http://}, \verb{https://}, \verb{ftp://}, or
\verb{ftps://} will be automatically downloaded. Remote compressed files
(\code{.gz}, \code{.bz2}, \code{.xz}, \code{.zip}) will be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, wrap the input with \code{I()}.}

\item{parse_info}{if set to 'TRUE', the read_vcf function will split all the metadata stored in the "info" column and stores it into separate columns.
By default it is set to 'FALSE'.}

\item{col_names}{column names to use. Defaults to \code{def_names("vcf")} (see \code{\link{def_names}}).}

\item{col_types}{column types to use. Defaults to \code{def_types("vcf")} (see \code{\link{def_types}}).}
}
\value{
dataframe
}
\description{
VCF (Variant Call Format) file format is used to store variation data and its metadata.
Based on the used analysis program (e.g. GATK, freebayes, etc...), details within the VCF file can slightly differ.
For example, type of mutation is not mentioned as output for certain variant analysis programs.
the "read_vcf" function, ignores the first header/metadata lines and directly converts the data into a tidy dataframe.
The function will extract the type of mutation. By absence, it will derive the type of mutation from the "ref" and "alt" column.
}
