% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{fd_merge}
\alias{fd_merge}
\title{Merge ggfigdone databases}
\usage{
fd_merge(from, to = fd_get_db(), replace = "updated_date")
}
\arguments{
\item{from}{An object of class \code{fdObj} that will be merged from.}

\item{to}{An object of class \code{fdObj} that will be merged to. The default value is the default ggfigdone database.}

\item{replace}{A character string specifying the method to keep the figure with the unique ID. It can be either "updated_date" or "created_date".}
}
\value{
An object of class \code{fdObj} with the merged database.
}
\description{
This function merges two ggfigdone databases.
The function will update the figures in the 'to' database with the figures in the 'from' database.
If there is a figure with the same ID in both databases, the function will keep the figure with the latest updated date or created date.
}
\examples{
library(ggplot2)
## create ggfigdone database in a temporary directory
db_dir1 = file.path(tempdir(), "db1")
db_dir2 = file.path(tempdir(), "db2")
fo1 = fd_init(db_dir1, rm_exist = TRUE)
fo2 = fd_init(db_dir2, rm_exist = TRUE)

## Draw a ggplot figure
g = ggplot(mtcars, aes(x=wt, y=mpg)) + geom_point()

## Add the figure to the database
fd_add(g = g, name  = "fig1", fdObj = fo1)
fd_add(g = g + theme_classic(), name  = "fig2", fdObj = fo2)

## Merge the databases
fo_merge = fd_merge(from = fo1, to = fo2, replace = "updated_date")

## Show the updated ggfigdone database
print(fo_merge)

##
}
