% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{BuildModel}
\alias{BuildModel}
\alias{print.model}
\alias{print.dmi}
\title{Create a model object}
\usage{
BuildModel(
  p.map,
  responses,
  factors = list(A = "1"),
  match.map = NULL,
  constants = numeric(0),
  type = "norm",
  posdrift = TRUE,
  verbose = TRUE
)

\method{print}{model}(x, p.vector = NULL, ...)

\method{print}{dmi}(x, ...)
}
\arguments{
\item{p.map}{parameter map. This option maps a particular factorial design
to model parameters}

\item{responses}{specifying the response names and levels}

\item{factors}{specifying a list of factors and their levels}

\item{match.map}{match map. This option matches stimuli and responses}

\item{constants}{specifying the parameters with fixed values}

\item{type}{specifying model type, either "rd" or "norm".}

\item{posdrift}{a Boolean, switching between enforcing strict postive drift
rates by using truncated normal distribution. This option is only useful in
"norm" model type.}

\item{verbose}{Print p.vector, constants and model type}

\item{x}{a model object}

\item{p.vector}{parameter vector}

\item{...}{other arguments}
}
\description{
A model object consists of arraies with model attributes.
}
\examples{
model <- BuildModel(
        p.map     = list(a = "1", v = "1", z = "1", d = "1", t0 = "1",
                     sv = "1", sz = "1", st0 = "1"),
        constants = c(st0 = 0, d = 0, sz = 0, sv = 0),
        match.map = list(M = list(s1 = "r1", s2 = "r2")),
        factors   = list(S = c("s1", "s2")),
        responses = c("r1", "r2"),
        type      = "rd")
}
