% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_1d.R
\name{method_freqpoly_1d}
\alias{method_freqpoly_1d}
\title{Univariate frequency polygon HDR estimator}
\usage{
method_freqpoly_1d(bins = NULL)
}
\arguments{
\item{bins}{Number of bins. Defaults to normal reference rule (Scott, pg 59).}
}
\description{
Function used to specify univariate frequency polygon density estimator
for \code{get_hdr_1d()} and layer functions (e.g. \code{geom_hdr_rug()}).
}
\details{
For more details on the use and implementation of the \verb{method_*_1d()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
df <- data.frame(x = rnorm(1e3))

# Strip chart to visualize 1-d data
p <- ggplot(df, aes(x)) +
  geom_jitter(aes(y = 0), width = 0, height = 2) +
  scale_y_continuous(name = NULL, breaks = NULL) +
  coord_cartesian(ylim = c(-3, 3))

p

p + geom_hdr_rug(method = method_freqpoly_1d())

# The resolution of the frequency polygon estimator can be set via `bins`
p + geom_hdr_rug(method = method_freqpoly_1d(bins = 100))

# Can also be used with `get_hdr_1d()` for numerical summary of HDRs
res <- get_hdr_1d(df$x, method = method_freqpoly_1d())
str(res)

}
\references{
Scott, David W. Multivariate Density Estimation (2e), Wiley.
}
