% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_tmd.R
\name{gg_tmd}
\alias{gg_tmd}
\title{Tukey's Mean-Difference plot for one-way data}
\usage{
gg_tmd(df, vble, group, xlabel = "Mean", ylabel = "Difference", ...)
}
\arguments{
\item{df}{dataframe}

\item{vble}{numeric variable to be analized}

\item{group}{character or factor grouping variable}

\item{xlabel}{label for x-axis, defaults to "Mean"}

\item{ylabel}{label for y-axis, defaults to "Difference"}

\item{...}{parameters to be passed to geom_point(), such as size, color, shape.}
}
\value{
a ggplot
}
\description{
Returns Tukey's Mean-Difference plot for one-way data
}
\examples{
library(dplyr)
data(futbol)

# Multiple groups
gg_tmd(futbol, dist, longp)
gg_tmd(futbol, dist, longp, size = 0.4, color = "red", shape = 3)

# Only 2 groups
futbol \%>\%
  filter(longp \%in\% c("< 0.81 m", "0.81 a 0.90 m")) \%>\%
  gg_tmd(dist, longp)
}
