% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrow_shapes.R
\name{arrow_ornaments}
\alias{arrow_ornaments}
\alias{arrow_head_wings}
\alias{arrow_fins_feather}
\alias{arrow_head_line}
\alias{arrow_fins_line}
\alias{arrow_cup}
\alias{arrow_head_minimal}
\alias{arrow_fins_minimal}
\title{Arrow ornament functions}
\usage{
arrow_head_wings(offset = 20, inset = 30)

arrow_fins_feather(indent = 0.3, outdent = indent, height = 0.5)

arrow_head_line(angle = 30, lineend = "butt")

arrow_fins_line(angle = 30, lineend = "butt")

arrow_cup(lineend = "round", angle = NULL)

arrow_head_minimal(angle = 45)

arrow_fins_minimal(angle = 45)
}
\arguments{
\item{offset, angle}{A \code{numeric(1)} giving an angle in degrees for the angle
between the line and tip.}

\item{inset}{A \code{numeric(1)} giving an angle in degrees for the angle inside
the tip of the arrowhead.}

\item{indent, outdent}{A \code{numeric(1)} giving the fraction of the feather
feather length to offset the notch and the end respectively.}

\item{height}{A \code{numeric(1)} ratio between the length of the feathers and the
height of the feathers.}

\item{lineend}{A \code{character(1)}, one of \code{"butt"}, \code{"square"}, \code{"round"} or
\code{"parallel"}. For \code{arrow_cup()}, only \code{"butt"} and \code{"round"} are allowed.}
}
\value{
A \verb{<matrix[n, 2]>} with \code{x} and \code{y} columns describing a polygon.
It has a \code{notch_angle} attribute that is used fusing the fins/head to the
shaft of the arrow. They can be given to an arrow plotting function.
}
\description{
There are two types of arrow ornament functions: functions for arrow heads,
and functions for arrow fins. The heads and fins can be used interchangeably,
but the name makes it clearer what is suitable.
}
\details{
The convention for these functions is that the arrow shaft is fused to the
ornament at the (0,0) point and the ornaments ends at the (1,0) point.
}
\section{Functions}{
\itemize{
\item \code{arrow_head_wings()}: Places two triangles at either side of the line. Let ABC be a triangle,
where A is at the end of the line, B is on the line and C is the arrow
wingtip. Then \code{offset} is the angle at corner A and \code{inset} is the angle at
corner C.

\item \code{arrow_fins_feather()}: Places trapezoids at either side of the line. Let ABCD be a quadrilateral
shape, where A is at the end of the line, B is on the line, and CD is
parallel to AB, but offset from the line. Then, \code{indent} is the distance
along the line between A and D and \code{outdent} is the distance along the line
between B and C.

\item \code{arrow_head_line()}: A line as an arrow head.

\item \code{arrow_fins_line()}: A line as an arrow fin.

\item \code{arrow_cup()}: A curved line some fixed distance away from the point to be resected,
resembling a 'cup' shape.

\item \code{arrow_head_minimal()}: This is a 'fake' arrow head who in practice doesn't draw anything, but
sets the \code{notch_angle} attribute such that the arrow shaft is whittled into
a triangular point.

\item \code{arrow_fins_minimal()}: This is a 'fake' arrow head who in practise doesn't draw anything, but
sets the \code{notch_angle} attribute such that a triangle is taken out of the
arrow shaft.

}}
\examples{
# Plotting winged head
plot(c(-0.5, 1), c(-0.6, 0.6), type = "n")
polygon(arrow_head_wings(), col = "gray")

# Plotting feather fins
plot(c(0, 1), c(-0.25, 0.25), type = "n")
polygon(arrow_fins_feather(), col = "gray")
}
