% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_boxplots.R
\name{gg_boxplots}
\alias{gg_boxplots}
\title{Boxplots using ggplot2}
\usage{
gg_boxplots(
  data,
  x,
  y,
  group_var = NULL,
  jitter_points = FALSE,
  horizontal = FALSE,
  point_size = 1,
  alpha = 1,
  color_palette = NA,
  direction = 1,
  show_mean = FALSE
)
}
\arguments{
\item{data}{provided dataset}

\item{x}{A character string indicating the factor of the data}

\item{y}{A character string indicating the response of the data}

\item{group_var}{A character string indicating the groups for facet_wrap}

\item{jitter_points}{Overlay jittered points to boxplots. Default is FALSE.}

\item{horizontal}{Determine whether to change the orientation of the plot. Default is FALSE}

\item{point_size}{Change size of points (outliers) in boxplots}

\item{alpha}{The alpha transparency, a number in [0,1]}

\item{color_palette}{A character string indicating the color map option to use. Eight options are available: "viridis","cividis","magma","inferno","plasma","rocket","mako","turbo"}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed}

\item{show_mean}{Display the mean for each boxplot. Default is FALSE}
}
\value{
Boxplots created with ggplot2
}
\description{
Boxplots using ggplot2
}
\examples{
data <- ToothGrowth
data$dose <- factor(data$dose,levels = c(0.5, 1, 2),labels = c("D0.5", "D1", "D2"))
gg_boxplots(data,y= "len",x= "dose",alpha=0.6)
gg_boxplots(data,y = "len",x= "dose",group_var = "supp",
alpha=0.6,color_palette = 'viridis',jitter_points=TRUE)
}
