% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gars.R
\name{gars_fwd}
\alias{gars_fwd}
\alias{gars_rev}
\title{Global Area Reference System (GARS)}
\usage{
gars_fwd(x, precision = 2L)

gars_rev(gars)
}
\arguments{
\item{x}{A two-column matrix or data frame of coordinates (longitude, latitude)
in decimal degrees, or a list with longitude and latitude components.
Can also be a length-2 numeric vector for a single point.}

\item{precision}{Integer specifying the precision level (0, 1, or 2):
\itemize{
\item 0: 30-minute cells (5-character code)
\item 1: 15-minute quadrants (6-character code)
\item 2: 5-minute keypads (7-character code, maximum precision)
}}

\item{gars}{Character vector of GARS codes to convert back to coordinates.}
}
\value{
\itemize{
\item \code{gars_fwd()}: Character vector of GARS codes.
\item \code{gars_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: Longitude of cell center in decimal degrees
\item \code{lat}: Latitude of cell center in decimal degrees
\item \code{precision}: Precision level (0, 1, or 2)
\item \code{lat_resolution}: Cell half-height in degrees
\item \code{lon_resolution}: Cell half-width in degrees
}
}
}
\description{
Convert geographic coordinates (longitude/latitude) to GARS codes,
or convert GARS codes back to coordinates.
}
\details{
GARS (Global Area Reference System) is a standardized geospatial reference
system used by the US military. It divides the Earth into cells using a
hierarchical grid:
\itemize{
\item \strong{30-minute cells}: The base grid (720 × 360 cells globally)
\item \strong{15-minute quadrants}: Each 30-minute cell divided into 4 quadrants (1-4)
\item \strong{5-minute keypads}: Each quadrant divided into 9 keypads (1-9, like a phone keypad)
}

A GARS code consists of:
\itemize{
\item 3-digit longitude band (001-720)
\item 2-letter latitude band (AA-QZ)
\item Optional 1-digit quadrant (1-4)
\item Optional 1-digit keypad (1-9)
}

Example: "006AG39" = 5-minute cell at approximately (-177°, -89.5°)
}
\examples{
# Basic conversion
gars_fwd(c(-74, 40.7))

# Different precision levels
gars_fwd(c(-74, 40.7), precision = 0)  # 30-minute
gars_fwd(c(-74, 40.7), precision = 1)  # 15-minute
gars_fwd(c(-74, 40.7), precision = 2)  # 5-minute

# Multiple points
pts <- cbind(lon = c(-74, 139.7, 0), lat = c(40.7, 35.7, 51.5))
gars_fwd(pts, precision = 2)

# Reverse conversion
gars_rev(c("213LR29", "498MH18", "361NS47"))
}
\seealso{
\code{\link[=mgrs_fwd]{mgrs_fwd()}} for Military Grid Reference System, another military
grid system.
}
