% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_geo.R
\name{get_metadata}
\alias{get_metadata}
\alias{get_metadata.acs_5yr_geo}
\title{Get the metadata layer}
\usage{
get_metadata(geo)

\method{get_metadata}{acs_5yr_geo}(geo)
}
\arguments{
\item{geo}{An \code{acs_5yr_geo} object.}
}
\value{
A \code{tibble} object.
}
\description{
The metadata layer includes the names and description through various fields
of the variables contained in the reports.
}
\details{
The way to select the variables we want to work with is to filter this layer
and subsequently set it as the object's metadata layer using the \code{set_metadata()}
function.
}
\examples{

act <- anrc_2021_x01 |>
  select_report(report = "B01002-Median Age By Sex")

geo <- act |>
  as_acs_5yr_geo()

metadata <- geo |>
  get_metadata()

}
\seealso{
Other data exploitation and export functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_acs_5yr_geo}()},
\code{\link{as_flat_table}()},
\code{\link{as_geomultistar}()},
\code{\link{as_star_database}()},
\code{\link{set_metadata}()}
}
\concept{data exploitation and export functions}
