% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{plot_ba_curve}
\alias{plot_ba_curve}
\title{Plots the Bearing Area Curve}
\usage{
plot_ba_curve(x, divisions = FALSE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{divisions}{Logical, defaults to \code{FALSE}. If
\code{TRUE}, divisions of the curve will be plotted.
See details section for more information.}
}
\value{
Plots the Bearing Area curve.
}
\description{
Calculates and plots the Bearing Area curve for a raster
or matrix using the \code{bearing_area()} function (with correctly
rotated results).
}
\details{
If \code{divisions = TRUE}, the lines representing the
best fit line to the flattest 40 percent of the curve will be
shown, as well as both the x and y interception points
of that line.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# plot the bearing area curve
plot_ba_curve(normforest, divisions = TRUE)
}
