% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolevel.R
\name{get_empty_geometry_instances}
\alias{get_empty_geometry_instances}
\alias{get_empty_geometry_instances.geolevel}
\title{Get empty geometry instances}
\usage{
get_empty_geometry_instances(gl, geometry)

\method{get_empty_geometry_instances}{geolevel}(gl, geometry = NULL)
}
\arguments{
\item{gl}{A \code{geolevel} object.}

\item{geometry}{A string, type of geometry of the layer.}
}
\value{
A \code{tibble}.
}
\description{
Get the instances of the data table that do not have associated geometry for
the specified geometry type.
}
\examples{

layer_us_state <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "state"),
    get_level_layer(gd_us, "state"),
    by = c("statefp", "division", "region", "stusps", "name")
  ) |>
  sf::st_as_sf()

us_state_point <-
  coordinates_to_geometry(layer_us_state,
                          lon_lat = c("intptlon", "intptlat"))

state <-
  geolevel(name = "state",
           layer = layer_us_state,
           key = "statefp",
           snake_case = TRUE) |>
  add_geometry(layer = us_state_point)

empty_geometry_instances <- state |>
  get_empty_geometry_instances(geometry = "point")

}
\seealso{
\code{\link{geodimension}}, \code{\link{relate_levels}}

Other geolevel definition functions: 
\code{\link{add_geometry}()},
\code{\link{check_key}()},
\code{\link{complete_point_geometry}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{geolevel}()},
\code{\link{get_geometry}()}
}
\concept{geolevel definition functions}
