% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vehpts.R
\docType{data}
\name{vehicle_pts}
\alias{vehicle_pts}
\title{Abandoned Vehicles (2016).}
\format{An sf data frame with 2635 rows, 10 variables, and a geometry column:
\describe{
  \item{CreationDt}{Date created}
  \item{Address}{Address of abandoned vehicle}
  \item{ZIPCode}{Zip code of abandoned vehicle}
  \item{X}{Projected X, EPSG 32616}
  \item{Y}{Projected Y, EPSG 32616}
  \item{Ward}{Ward ID}
  \item{PoliceD}{Police district ID}
  \item{Comm}{Community area ID}
  \item{Latitude}{Latitude of vehicle}
  \item{Longitude}{Longitude of vehicle}
  \item{geometry}{POINT}
}}
\source{
\url{https://data.cityofchicago.org/Service-Requests/311-Service-Requests-Abandoned-Vehicles/3c9v-pnva}
}
\usage{
vehicle_pts
}
\description{
Point locations of abandoned vehicles in Chicago in September 2016.
}
\details{
Sf object, unprojected. EPSG 4326: WGS84.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(sf)
  data(vehicle_pts)

  plot(vehicle_pts["CreationDt"])
}
}
\keyword{datasets}
