% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-max-lvl.R
\encoding{UTF-8}
\name{gb_get_max_adm_lvl}
\alias{gb_get_max_adm_lvl}
\title{Get the highest administrative level available for a given country}
\source{
geoBoundaries API Service \url{https://www.geoboundaries.org/api.html}.
}
\usage{
gb_get_max_adm_lvl(
  country = "all",
  release_type = c("gbOpen", "gbHumanitarian", "gbAuthoritative")
)
}
\arguments{
\item{country}{A character vector of country codes. It can be either
\code{"all"} (that would return the data for all countries), a vector of country
names or ISO3 country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{release_type}{One of \code{"gbOpen"}, \code{"gbHumanitarian"},
\code{"gbAuthoritative"}. For most users, we suggest using \code{"gbOpen"}
(the default), as it is CC-BY 4.0 compliant and can be used for most
purposes so long as attribution is provided:
\itemize{
\item \code{"gbHumanitarian"} files are mirrored from
\href{https://www.unocha.org/}{UN OCHA}, but may have more restrictive
licensing.
\item \code{"gbAuthoritative"} files are mirrored from UN SALB, and cannot be used
for commercial purposes, but are verified through in-country processes.
}}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with the country names and corresponding highest
administrative level.
}
\description{
Get a summary of selected or all countries and their highest administrative
level available in geoBoundaries.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || interactive()) withAutoprint(\{ # examplesIf}
all <- gb_get_max_adm_lvl()
library(dplyr)

# Countries with only 1 level available
all |>
  filter(maxBoundaryType == 1)

# Countries with level 4 available
all |>
  filter(maxBoundaryType == 4)
\dontshow{\}) # examplesIf}
}
\seealso{
Other metadata functions: 
\code{\link{gb_get_metadata}()}
}
\concept{metadata functions}
