% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admixture.R
\name{profile_admixture}
\alias{profile_admixture}
\title{Compute the z-score (and more) for admixed hypotheses}
\usage{
profile_admixture(x0, df, hyp = NULL, grouping = "meta",
  return_all = FALSE, calc_logP = TRUE, ...)
}
\arguments{
\item{x0}{A data frame/tibble with two columns: `locus` and `x0`}

\item{df}{A tibble of reference profiles (as for `genogeo`)}

\item{hyp}{If NULL all levels of `grouping` is crossed and looped over as pairwise hypotheses. 
If a single level of `grouping`, this value is crossed with the remaining levels.
If vector of two levels this is the only tested hypothesis.}

\item{grouping}{Should the calculations be for meta populations ("meta") or sample populations ("pop")?}

\item{return_all}{Should z-score be returned (FALSE) or all locus results (TRUE)?}

\item{calc_logP}{Should log P(Geno|Hyp) be calculated (TRUE) or not (FALSE)?}

\item{...}{additional arguments passed on to other functions}
}
\value{
A tibble of z-scores, or a list of pairwise results if `return_all = TRUE`
}
\description{
Compute the z-score (and more) for admixed hypotheses
}
