% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMesh.R
\name{getMesh}
\alias{getMesh}
\title{Get MeSH geneset and geneset_name
MeSH is the annotation used for MEDLINE/PubMed articles and is manually curated by NLM (U.S. National Library of Medicine).
Geneset is a data.frame of 2 columns with term id and gene id;
Geneset_name is a data.frame of 2 columns with term id and term description}
\usage{
getMesh(
  org = "human",
  method = c("gendoo", "gene2pubmed", "RBBH"),
  category = c("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "Z"),
  download.method = NULL,
  data_dir = NULL
)
}
\arguments{
\item{org}{Organism mesh_name from `mesh_org`.}

\item{method}{Method of mapping MeSH ID to gene ID. Choose one from "gendoo", "gene2pubmed" or "RBBH" (mainly for some minor species).
See also `mesh_metadata`.}

\item{category}{MeSH descriptor categories from `mesh_metadata` (refer to: https://wikipedia.org/wiki/List_of_MeSH_codes).}

\item{download.method}{"auto" (as default if NULL), "wininet" (for windows)}

\item{data_dir}{data saving location, default is the package data directory}
}
\value{
A list including geneset and geneset name.
}
\description{
Get MeSH geneset and geneset_name
MeSH is the annotation used for MEDLINE/PubMed articles and is manually curated by NLM (U.S. National Library of Medicine).
Geneset is a data.frame of 2 columns with term id and gene id;
Geneset_name is a data.frame of 2 columns with term id and term description
}
\examples{
\donttest{
x = getMesh(org = "human", method = "gendoo", category = "A", data_dir = tempdir())
}
}
