library(testthat)

test_that("rss.prop.test works as expected",{
  set.seed(123)
  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,10,8),p=0.2)
  result=rss.prop.test(data=rss.prop.data, alpha=0.05, alternative="two.sided", p0=0.2)
  expect_equal(result$RSS_prop, 0.2333333, tolerance = 1e-3)
  expect_equal(result$p.value, 0.6370746, tolerance = 1e-3)
  expect_equal(result$CI, c(0.09485704, 0.37180963), tolerance = 1e-3)
  expect_equal(result$pstat, 0.4717929, tolerance = 1e-3)
  
})

test_that("rss.prop.test handles wrong input with error",{
  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,8,10),p=0.4)
  expect_error(rss.prop.test(data=rss.prop.data, alpha=1.1, alternative="two.sided", p0=0.2),
               "alpha is out of bound.")
  expect_error(rss.prop.test(data=rss.prop.data, alpha=1.1, alternative="one-sided", p0=0.2),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.prop.test(data=rss.prop.data[,1], alpha=0.05, alternative="two.sided", p0=0.2),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.prop.test(data=rss.prop.data[,2], alpha=0.05, alternative="two.sided", p0=0.2),
               "The input data must contain 'rank' and 'y' variables.")
})
