library(testthat)

test_that("rss.design works as expected",{
  set.seed(123)
  rss.data<-rss.simulation(H=3,nsamp=c(6,8,20),dist="normal", rho=0.8,delta=0)
  result=rss.design(data=rss.data)
  expect_equal(as.numeric(result$original.n), c(6,8,20))
  expect_equal(as.numeric(result$Integer.Neyman), c(8,9,17))
  expect_equal(as.numeric(result$Adj.Neyman), c(8,9,20))
  expect_equal(as.numeric(result$LRC.allocation), c(6,8,20))

  result=rss.design(H=3,org.n=c(5,7,3),var.h=c(1,2,5))
  expect_equal(as.numeric(result$original.n), c(5,7,3))
  expect_equal(as.numeric(result$Integer.Neyman), c(3,5,7))
  expect_equal(as.numeric(result$Adj.Neyman), c(5,7,7))
  expect_equal(as.numeric(result$LRC.allocation), c(5,7,7))

  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(10,15,20),p=0.5)
  result.prop=rss.design(rss.prop.data,prop=TRUE)
  expect_equal(as.numeric(result.prop$original.n), c(10,15,20))
  expect_equal(as.numeric(result.prop$Neyman.proportion), c(12.63132, 19.37126, 12.99743), tolerance = 1e-3)
})

test_that("rss.design handles wrong input with error",{
  rss.data=rss.simulation(H=3,nsamp=c(6,7,8),dist="normal", rho=0.8,delta=0)
  expect_error(rss.design(data=rss.data,H=3,org.n=c(5,7,3),var.h=c(2,3,5)),
               "Please provide either data or \\(H, org.n, and var.h\\), not both.")
  expect_error(rss.design(data=rss.data[,1]),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.design(data=rss.data[,2]),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.design(H=3,org.n=c(5,7,3)),
               "Error: Please provide either data or all of H, org.n, and var.h.")
  expect_error(rss.design(H=3,var.h=c(2,3,5)),
               "Error: Please provide either data or all of H, org.n, and var.h.")
  expect_error(rss.design(org.n=c(5,7,3),var.h=c(2,3,5)),
               "Error: Please provide either data or all of H, org.n, and var.h.")
  expect_error(rss.design(H=3,org.n=c(5,7,3),var.h=c(2,3,5,3)),
               "Error: Length of org.n and var.h must match the set size H.")
  expect_error(rss.design(H=3,org.n=c(5,7),var.h=c(2,3,5)),
               "Error: Length of org.n and var.h must match the set size H.")
  expect_error(rss.design(H=4,org.n=c(5,7,3),var.h=c(2,3,5)),
               "Error: Length of org.n and var.h must match the set size H.")

  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(15,12,10),p=0.6)
  expect_error(rss.design(prop=TRUE),
               "Please provide data.")
  expect_error(rss.design(data=rss.prop.data,H=3,prop=TRUE),
               "H, org.n, and var.h are not needed for proportion tests.")
  expect_error(rss.design(data=rss.prop.data,org.n=c(15,12,10),prop=TRUE),
               "H, org.n, and var.h are not needed for proportion tests.")
  expect_error(rss.design(data=rss.prop.data,var.h=0.3,prop=TRUE),
               "H, org.n, and var.h are not needed for proportion tests.")
})
