% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.sampling.R
\name{rss.sampling}
\alias{rss.sampling}
\title{Generate ranked set samples}
\usage{
rss.sampling(ID, Y = NULL, X, H, nsamp)
}
\arguments{
\item{ID}{A numeric vector of subject IDs from the population. IDs must be unique.}

\item{Y}{A numeric vector of interested outcome variable. If Y=NULL (default), only IDs and ranks are returned.}

\item{X}{A numeric vector of auxiliary variable used for ranking. Must have the same length as ID.}

\item{H}{The RSS set size}

\item{nsamp}{A numeric vector specifying the sample allocation for each stratum.}
}
\value{
A data frame with the following columns:
\item{ID}{The sampled subjects' IDs.}
\item{rank}{The rank information assigned to each sample.}
\item{y}{The generated ranked set samples of the outcome variable Y. If Y=NULL, this column is not included.}
}
\description{
The rss.sampling function generates ranked set samples by performing ranked set sampling directly on a given population data set using an auxiliary variable (X) and subject IDs. The outcome variable (Y) is optional. If Y=NULL, the function returns only the sampled IDs and ranks.
}
\details{
This function performs balanced or unbalanced ranked set sampling from a given data set. The length of the sample allocation vector (nsamp) must match the set size (H). The subject ID, outcome variable (Y), and auxiliary variable (X) must have the same length. If Y is not provided (Y=NULL), the function returns only the sampled IDs and their ranks without generating Y values.
}
\examples{
## Example 1: Balanced RSS with equal sample sizes.
data(iris)
id=1:nrow(iris)
rss.data=rss.sampling(ID=id, Y=iris$Sepal.Length, X=iris$Petal.Length, H=3,nsamp=c(6,6,6))

## Example 2: Unbalanced RSS with different sample sizes.
rss.data=rss.sampling(ID=id, Y=iris$Sepal.Length, X=iris$Petal.Length, H=3, nsamp=c(6,10,8))

# Check the structure of the RSS data
colnames(rss.data) # include "ID", "rank", and "Y"
head(rss.data$ID)
head(rss.data$rank)

## Example 3: If Y is not available, retrieve sampled IDs and ranks only.
rss.data=rss.sampling(ID=id, X=iris$Petal.Length, H=3,nsamp=c(6,10,8))

# Check the structure of the RSS data
colnames(rss.data) # include "ID" and "rank"
head(rss.data$ID)
head(rss.data$rank)
head(rss.data$y)

}
