% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.prop.sampling.R
\name{rss.prop.sampling}
\alias{rss.prop.sampling}
\title{Generate ranked set samples for proportions}
\usage{
rss.prop.sampling(ID, X, H, nsamp)
}
\arguments{
\item{ID}{A numeric vector of subject IDs from the population. IDs must be unique.}

\item{X}{A numeric vector of auxiliary variable used for ranking. Must have the same length as ID.}

\item{H}{The RSS set size}

\item{nsamp}{A numeric vector specifying the sample allocation for each stratum.}
}
\value{
A data frame with the following columns:
\item{ID}{The sampled subjects' IDs.}
\item{rank}{The rank information assigned to each sample.}
}
\description{
The rss.prop.sampling function generates ranked set samples for proportions by performing ranked set sampling directly on a given population data set using an auxiliary variable (X) and subject IDs.
}
\details{
This function performs balanced or unbalanced ranked set sampling for proportions from a given data set. The length of the sample allocation vector (nsamp) must match the set size (H). The subject ID and auxiliary variable (X) must have the same length.
}
\examples{
## Example 1: Balanced RSS with equal sample sizes.
data(iris)
id=1:nrow(iris)
X=ifelse(iris$Sepal.Length<5.8,0,1)
rss.prop.data=rss.prop.sampling(ID=id, X=X, H=3,nsamp=c(6,6,6))

## Example 2: Unbalanced RSS with different sample sizes.
rss.prop.data=rss.prop.sampling(ID=id, X=X, H=3, nsamp=c(6,10,8))

# Check the structure of the RSS data
colnames(rss.prop.data) # include "ID", "rank", and "Y"
head(rss.prop.data$ID)
head(rss.prop.data$rank)

}
