% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProteins_from_tax_ids.R
\name{getProteins_from_tax_ids}
\alias{getProteins_from_tax_ids}
\title{Get the RefSeq protein identifiers for the given taxonomic species}
\usage{
getProteins_from_tax_ids(arch_ids, taxonIds)
}
\arguments{
\item{arch_ids}{A string with the electronic links for the SPARCLE.}

\item{taxonIds}{A vector string with taxonomy ids; Legume species available
in RefSeq, by default.}
}
\value{
RefSeq protein identifiers for selected species.
}
\description{
Parse the RefSeq database using protein architecture identifiers (SPARCLE dabatse)
and extract the protein ids. for the selected taxonomic species.
}
\examples{
filtered_archids <- c("12034184")
medicago <- c(3880)
getProteins_from_tax_ids(filtered_archids, medicago)

}
\author{
Jose V. Die
}
