\encoding{UTF-8}

\name{cons}
\alias{cons}
\alias{consTPM}
\alias{consVSA}

\title{Consolidation Process in a Homogeneous Cohesive Soil Layer}

\description{
Computer experiments and variational sensitivities of a consolidation process in a homogeneous cohesive soil layer with an inhomogeneous permeability distribution.
}

\usage{
consTPM
consVSA
}


\format{
The \code{\link{data.frame}} \code{consTPM} contains 50 observations of 5 variables:

\tabular{rll}{
	[, 1] \tab \code{disp}	  \tab solid vertical displacement \eqn{\rm u_{S2}} in \eqn{\rm m} \cr
	[, 2] \tab \code{stiff}   \tab oedometric stiffness \eqn{\rm E_{oed}} in \eqn{\rm MPa} \cr
	[, 3] \tab \code{poisson} \tab Poisson's ratio \eqn{\nu} \cr
	[, 4] \tab \code{mass}	  \tab reference mass density \eqn{\rho_{\rm 0S}^{\rm SR}} in \eqn{\rm kg/m^3} \cr
	[, 5] \tab \code{volume}  \tab reference solid volume fraction \eqn{\rm n_{0S}^S} \cr
}

The \code{\link{data.frame}} \code{consVSA} contains 50 observations of 4 variables:

\tabular{rll}{
	[, 1] \tab \code{stiff}	  \tab sensitivity for oedometric stiffness \eqn{\rm E_{oed}} \cr
	[, 2] \tab \code{poisson} \tab sensitivity for Poisson's ratio \eqn{\nu} \cr
	[, 3] \tab \code{mass}	  \tab sensitivity for reference mass density \eqn{\rho_{\rm 0S}^{\rm SR}} \cr
	[, 4] \tab \code{volume}  \tab sensitivity for reference solid volume fraction \eqn{\rm n_{0S}^S} \cr
}
}

\details{
The data sets provided here contain computer experiments and variational sensitivities for a specific example of a settlement calculation.

The \code{\link{data.frame}} \code{consTMP} consists of computer experiments obtained by a deterministic simulator that
models a consolidation process in a homogeneous cohesive soil layer as a result of the filling of a railroad dam.
Calculations are preformed using the finite element method, whereby the underlying partial differential equations 
used to describe the soil characteristics are based on the theory of porous media.
The response analyzed here is the solid vertical displacement \code{disp} after 20 days in the middle node at the top of the soil layer,
which depends on four uncertain material parameters, namely the oedometer stiffness \code{stiff}, Poisson's ratio \code{poisson}, reference mass density \code{mass}, 
and reference solid volume fraction \code{volume}.
The inputs are based on a Latin hypercube sample that has been transformed componentwise to the domains below.
For uncertainty quantification, the following distributions of the inputs can be assumed.
\tabular{lrr}{
	Input 			 			 \tab Domain 			 \tab Distribution \cr
	\eqn{\rm E_{oed}} 			 \tab \eqn{[20, 30]} 	 \tab \eqn{\mathcal{LN}(3.198, 0.05211)} \cr
	\eqn{\nu} 		 			 \tab \eqn{[0.25 0.30]}  \tab \eqn{\mathcal{U}(0.25 0.30)}\cr
	\eqn{\rho_{\rm 0S}^{\rm SR}} \tab \eqn{[2000, 2500]} \tab \eqn{\mathcal{LN}(7.712, 0.02868)} \cr
	\eqn{\rm n_{0S}^S}			 \tab \eqn{[0.50, 0.65]} \tab \eqn{\mathcal{U}(0.50, 0.65)} \cr
}
Note, \eqn{\mathcal{LN}(\mu, \sigma)} is the log-normal distribution with mean \eqn{\mu} and standard deviation \eqn{\sigma} of the logarithm
and \eqn{\mathcal{U}(a,b)} denotes the continuous uniform distribution over the interval \eqn{[a,b]}.

The \code{\link{data.frame}} \code{consVSA} contains the variational sensitivities, 
i.e. the partial derivatives of the solid vertical displacement at the inputs in \code{consTPM}.
These were determined using the variational sensitivity analysis.
}

\source{
Both data sets were generated by Carla Henning as part of her dissertation.
She has granted permission to publish the data.
}

\references{
Henning, C. (2025). \emph{Analytical Development of the Variational Sensitivity Analysis for the Theory of Porous Media as Extension for a Gradient-Enhanced Gaussian Process Regression.} Ph.D. thesis, Institute of Structural Mechanics and Dynamics in Aerospace Engineering, University of Stuttgart. \doi{10.18419/opus-16260}.
}


\seealso{
\code{\link{gekm}} for fitting (gradient-enhanced) Kriging models.

\code{\link{plot.gekm}} for plotting the results of a leave-one-out cross-validation.
}


\examples{
# Structure of the data frames
str(consTPM)
str(consVSA)

# Summary of the data frames
summary(consTPM)
summary(consVSA)

# Fit a gradient-enhanced Kriging model for the solid vertical displacement 
# with Matérn 3/2 correlation function and first-order polynomial trend.
# Note that 'ncalls = 3' is set for illustrative purposes only. 
# In practice, it is advisable to choose a higher value for 'ncalls' or
# to retain the default value.
mod <- gekm(disp ~ ., data = consTPM, deriv = consVSA, covtype = "matern3_2", ncalls = 3)

# Model summary
summary(mod)

# Plot leave-one-out cross-validation results
plot(mod, add.interval = TRUE, col = 4, pch = 16, panel.first = {grid(); abline(0, 1)})
}

\keyword{datasets}