% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_funs.R
\name{grab_response}
\alias{grab_response}
\title{Grab a vector of responses from a model object}
\usage{
grab_response(data, formula)
}
\arguments{
\item{data}{data.frame from which to extract the vector of responses}

\item{formula}{model formula}
}
\value{
a \code{\link[stats]{model.response}}
}
\description{
Grab a vector of responses from a model object
}
\examples{
# Grab vector of responses for the first ten rows of iris data
fit <- lm(Sepal.Width ~ Petal.Width, data = iris)
grab_response(
  data = iris[1:10, ],
  formula(fit))
}
