% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_funs.R
\docType{methods}
\name{create_GFUN}
\alias{create_GFUN}
\alias{create_GFUN,m_estimation_basis-method}
\alias{create_GFUN,m_estimation_basis,m_estimation_basis-method}
\title{Creates a function that sums over psi functions}
\usage{
create_GFUN(object, ...)

\S4method{create_GFUN}{m_estimation_basis}(object)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{m_estimation_basis}}}

\item{...}{additional arguments passed to other methods}
}
\value{
a function
}
\description{
From a list of \eqn{\psi(O_i, \theta)}{\psi(O_i, \theta)} for i = 1, ..., m,
creates \eqn{G_m = \sum_i \psi(O_i, \theta)}{G_m = \sum_i \psi(O_i, \theta)},
called \code{GFUN}. Here, \eqn{\psi(O_i, \theta)}{\psi(O_i, \theta)} is the
*inner* part of an \code{estFUN}, in that the data is fixed and \eqn{G_m}{G_m}
is a function of \eqn{\theta)}{\theta}.
}
\examples{
myee <- function(data){
   function(theta){
    c(data$Y1 - theta[1],
     (data$Y1 - theta[1])^2 - theta[2])
   }
 }
mybasis <- create_basis(
   estFUN = myee,
   data   = geexex)
f <- grab_GFUN(create_GFUN(mybasis))

# Evaluate GFUN at mean and variance: should be close to zero
n <- nrow(geexex)
f(c(mean(geexex$Y1), var(geexex$Y1) * (n - 1)/n))


}
