% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evgram.R
\name{evgram}
\alias{evgram}
\title{Empirical (semi-)variogram}
\usage{
evgram(
  formula,
  data,
  coordnames = NULL,
  nbins = 10,
  maxd = NULL,
  angle = 0,
  ndir = 1,
  type = "standard",
  npmin = 2,
  longlat = FALSE,
  verbose = TRUE,
  invert = TRUE
)
}
\arguments{
\item{formula}{A formula describing the relationship
between the response and any covariates of interest,
e.g., response ~ 1.  The variogram is computed for the
residuals of the linear model \code{lm(formula, data)}.}

\item{data}{A \code{data.frame},
\code{SpatialPointsDataFrame},
\code{SpatialPixelsDataFrame}, or
\code{SpatialGridDataFrame} object.}

\item{coordnames}{The columns of \code{data} containing
the spatial coordinates, provided as a formula (e.g.,
\code{~ x + y}), column numbers (e.g., \code{c(1, 2)}),
or column names (e.g., \code{c("x", "y")}). The default
is \code{NULL}.}

\item{nbins}{The number of bins (tolerance regions) to
use when estimating the empirical semivariogram.}

\item{maxd}{The maximum distance used when calculating
the semivariogram.  Default is NULL, in which case half
the maximum distance between coordinates is used.}

\item{angle}{A single value (in degrees) indicating the
starting direction for a directional variogram.  The
default is 0.}

\item{ndir}{The number of directions for which to
calculate a empirical semivariogram.  The default is 1,
meaning calculate an omnidirectional semivariogram.}

\item{type}{The name of the estimator to use in the
estimation process.  The default is \code{"standard"}, the
typical method-of-moments estimator.  Other options
include \code{"cressie"} for the robust Cressie-Hawkins
estimator, and \code{"cloud"} for a semivariogram cloud
based on the standard estimator.  If \code{"cloud"} is specified,
the \code{nbins} argument is ignored.}

\item{npmin}{The minimum number of pairs of points to use
in the semivariogram estimator.  For any bins with
fewer points, the estimate for that bin is dropped.}

\item{longlat}{A logical indicating whether Euclidean
(\code{FALSE}) or Great Circle distance (WGS84
ellipsoid) (\code{longlat = TRUE}) should be used.
Default is \code{FALSE}.}

\item{verbose}{Logical value indicating whether
computation information should be printed. Default is
  \code{TRUE}.}

\item{invert}{A logical value indicating whether the axes
of the coordinates should be inverted (i.e., the x- and
y-axis are switched). The default is \code{TRUE} to
mimic results from other geostatistical R packages like
\code{gstat}, \code{geoR}, and other software like
\code{GSLIB} and \code{GeoEAS}. Set to \code{FALSE} to
use the typical x- and y-axes.}
}
\value{
Returns an \code{evgram}.
}
\description{
\code{evgram} computes the empirical semivariogram of
\code{data} based on the specified \code{formula}
indicating the response and trend. See Details. The
variogram is twice the semivariogram. If a trend is
specified, then the semivariogram is constructed using
the residuals of \code{lm(formula, data)}.
}
\details{
Note that the directions may be different from other
packages (e.g., \code{gstat} or \code{geoR} packages)
because those packages calculate angles clockwise from
the y-axis, which is a convention frequently seen in
geostatistics (e.g., the GSLIB software library). If
\code{invert = TRUE}, the directions should be the same.

Computing the empirical semivariogram for the residuals
of \code{lm(response ~ 1)} will produce identical results
to simply computing the empirical semivariogram from the
original response. However, if a trend is specified (the
righthand side of ~ has non-trival covariates), then the
empirical semivariogram of the residuals will differ
from that of the original response.  A trend should be
specified when the mean is non-stationary over the
spatial domain.
}
\examples{
data(co)
v = evgram(Al ~ 1, co, ~ easting + northing)
plot(v)
v2 = evgram(Al ~ 1, co, c("easting", "northing"), angle = 22.5, ndir = 4)
plot(v2)
}
\author{
Joshua French
}
