% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs_geodetecor.R
\name{srs_ecological_detector}
\alias{srs_ecological_detector}
\title{spatial rough set-based ecological detector}
\usage{
srs_ecological_detector(y, x1, x2, wt, alpha = 0.95)
}
\arguments{
\item{y}{Dependent variable, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x1}{Covariate \eqn{X_1}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x2}{Covariate \eqn{X_2}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{wt}{Spatial adjacency matrix.}

\item{alpha}{(optional) Confidence level of the interval,default is \code{0.95}.}
}
\value{
A list.
\describe{
\item{\code{T-statistic}}{the result of T statistic for spatial rough set-based ecological detector}
\item{\code{P-value}}{the result of P value for spatial rough set-based ecological detector}
\item{\code{Ecological}}{does one spatial feature \eqn{X_1} play a more important role than \eqn{X_2}}
}
}
\description{
spatial rough set-based ecological detector
}
\examples{
data('srs_table')
data('srs_wt')
srs_ecological_detector(srs_table$d,srs_table$a1,srs_table$a2,srs_wt)

}
\references{
Bai, H., Li, D., Ge, Y., Wang, J., & Cao, F. (2022). Spatial rough set-based
geographical detectors for nominal target variables. Information Sciences, 586, 525–539.
https://doi.org/10.1016/j.ins.2021.12.019
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
