% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{srs_query}
\alias{srs_query}
\alias{srs_get_name}
\alias{srs_find_epsg}
\alias{srs_is_geographic}
\alias{srs_is_derived_gcs}
\alias{srs_is_local}
\alias{srs_is_projected}
\alias{srs_is_compound}
\alias{srs_is_geocentric}
\alias{srs_is_vertical}
\alias{srs_is_dynamic}
\alias{srs_is_same}
\alias{srs_get_angular_units}
\alias{srs_get_linear_units}
\alias{srs_get_coord_epoch}
\alias{srs_get_utm_zone}
\alias{srs_get_axis_mapping_strategy}
\alias{srs_get_area_of_use}
\alias{srs_get_axes_count}
\alias{srs_get_axes}
\alias{srs_epsg_treats_as_lat_long}
\alias{srs_epsg_treats_as_northing_easting}
\alias{srs_get_celestial_body_name}
\title{Obtain information about a spatial reference system}
\usage{
srs_get_name(srs)

srs_find_epsg(srs, all_matches = FALSE)

srs_is_geographic(srs)

srs_is_derived_gcs(srs)

srs_is_local(srs)

srs_is_projected(srs)

srs_is_compound(srs)

srs_is_geocentric(srs)

srs_is_vertical(srs)

srs_is_dynamic(srs)

srs_is_same(
  srs,
  srs_other,
  criterion = "",
  ignore_axis_mapping = FALSE,
  ignore_coord_epoch = FALSE
)

srs_get_angular_units(srs)

srs_get_linear_units(srs)

srs_get_coord_epoch(srs)

srs_get_utm_zone(srs)

srs_get_axis_mapping_strategy(srs)

srs_get_area_of_use(srs)

srs_get_axes_count(srs)

srs_get_axes(srs, target_key = NULL)

srs_epsg_treats_as_lat_long(srs)

srs_epsg_treats_as_northing_easting(srs)

srs_get_celestial_body_name(srs)
}
\arguments{
\item{srs}{Character string containing an SRS definition in various
formats (e.g., WKT, PROJ.4 string, well known name such as NAD27, NAD83,
WGS84, etc., see \code{\link[=srs_to_wkt]{srs_to_wkt()}}).}

\item{all_matches}{Logical scalar. \code{TRUE} to return all identified matches
in a data frame, including a confidence value (0-100) for each match. The
default is \code{FALSE} which returns a character string in the form
\code{"EPSG:<code>"} for the first match (highest confidence).}

\item{srs_other}{Character string containing an SRS definition in various
formats(see above).}

\item{criterion}{Character string. One of \code{STRICT}, \code{EQUIVALENT},
\code{EQUIVALENT_EXCEPT_AXIS_ORDER_GEOGCRS}.
Defaults to \code{EQUIVALENT_EXCEPT_AXIS_ORDER_GEOGCRS}.}

\item{ignore_axis_mapping}{Logical scalar. If \code{TRUE}, sets
\code{IGNORE_DATA_AXIS_TO_SRS_AXIS_MAPPING=YES} in the call to \code{OSRIsSameEx()}
in the GDAL Spatial Reference System API. Defaults to \code{NO}.}

\item{ignore_coord_epoch}{Logical scalar. If \code{TRUE}, sets
\code{IGNORE_COORDINATE_EPOCH=YES} in the call to \code{OSRIsSameEx()}
in the GDAL Spatial Reference System API. Defaults to \code{NO}.}

\item{target_key}{Optional character string giving the coordinate system
part to query, either \code{"PROJCS"} or \code{"GEOGCS"} (case-insensitive)}
}
\description{
Bindings to a subset of the GDAL Spatial Reference System API
(\url{https://gdal.org/en/stable/api/ogr_srs_api.html}).
These functions return various information about a spatial reference
system passed as text in any of the formats supported by \code{\link[=srs_to_wkt]{srs_to_wkt()}}.
}
\details{
\code{srs_find_epsg()} tries to find a matching EPSG code.
Matching may be partial, or may fail. If \code{all_matches = TRUE}, returns a
data frame with entries sorted by decreasing match confidence (first
entry has the highest match confidence); the default is \code{FALSE} which
returns a character string in the form "EPSG:####" for the first match
(highest confidence). Wrapper of \code{OSRFindMatches()} in the GDAL SRS API.

\code{srs_get_name()} returns the SRS name.
Wrapper of \code{OSRGetName()} in the GDAL API.

\code{srs_is_geographic()} returns \code{TRUE}  if the root is a GEOGCS node.
Wrapper of \code{OSRIsGeographic()} in the GDAL API.

\code{srs_is_derived_gcs()} returns \code{TRUE} if the SRS is a derived geographic
coordinate system (for example a rotated long/lat grid).
Wrapper of \code{OSRIsDerivedGeographic()} in the GDAL API.

\code{srs_is_local()} returns \code{TRUE} if the SRS is a local coordinate system
(the root is a LOCAL_CS node).
Wrapper of \code{OSRIsLocal()} in the GDAL API.

\code{srs_is_projected()} returns \code{TRUE} if the SRS contains a PROJCS node
indicating a it is a projected coordinate system.
Wrapper of \code{OSRIsProjected()} in the GDAL API.

\code{srs_is_compound()} returns \code{TRUE} if the SRS is compound.
Wrapper of \code{OSRIsCompound()} in the GDAL API.

\code{srs_is_geocentric()} returns \code{TRUE} if the SRS is a geocentric coordinate
system.
Wrapper of \code{OSRIsGeocentric()} in the GDAL API.

\code{srs_is_vertical()} returns \code{TRUE} if the SRS is a vertical coordinate
system.
Wrapper of \code{OSRIsVertical()} in the GDAL API.

\code{srs_is_dynamic()} returns \code{TRUE} if the SRS is is a dynamic coordinate
system (relies on a dynamic datum, i.e., a datum that is not plate-fixed).
Wrapper of \code{OSRIsDynamic()} in the GDAL API. Requires GDAL >= 3.4.

\code{srs_is_same()} returns \code{TRUE} if two spatial references describe
the same system.
Wrapper of \code{OSRIsSame()} in the GDAL API.

\code{srs_get_angular_units()} fetches the angular geographic coordinate system
units. Returns a list of length two: the first element contains the unit
name as a character string, and the second element contains a numeric value
to multiply by angular distances to transform them to radians.
Wrapper of \code{OSRGetAngularUnits()} in the GDAL API.

\code{srs_get_linear_units()} fetches the linear projection units.
Returns a list of length two: the first element contains the unit
name as a character string, and the second element contains a numeric value
to multiply by linear distances to transform them to meters.
If no units are available, values of "Meters" and 1.0 will be assumed.
Wrapper of \code{OSRGetLinearUnits()} in the GDAL API.

\code{srs_get_coord_epoch()} returns the coordinate epoch, as decimal year
(e.g. 2021.3), or \code{0} if not set or not relevant.
Wrapper of \code{OSRGetCoordinateEpoch()} in the GDAL API. Requires GDAL >= 3.4.

\code{srs_get_utm_zone()} returns the UTM zone number or zero if \code{srs} isn't a
UTM definition. A positive value indicates northern hemisphere; a negative
value is in the southern hemisphere.
Wrapper of \code{OSRGetUTMZone()} in the GDAL API.

\code{srs_get_axis_mapping_strategy()} returns the data axis to CRS axis mapping
strategy as a character string, one of:
\itemize{
\item \code{OAMS_TRADITIONAL_GIS_ORDER}: for geographic CRS with lat/long order, the
data will still be long/lat ordered. Similarly for a projected CRS with
northing/easting order, the data will still be easting/northing ordered.
\item \code{OAMS_AUTHORITY_COMPLIANT}: the data axis will be identical to the CRS
axis.
\item \code{OAMS_CUSTOM}: custom-defined data axis
}

\code{srs_get_area_of_use()} is a wrapper of \code{OSRGetAreaOfUse()} in the GDAL API.
Returns a named list containing the following elements (or returns \code{NULL} if
the API call does not succeed):
\itemize{
\item \code{AreaName}: the area of use
\item \code{WestLongitudeDeg}: the western-most longitude expressed in degree, or
\code{NA} if the bounding box is unknown
\item \code{SouthLatitudeDeg}: the southern-most latitude expressed in degree, or
\code{NA} if the bounding box is unknown
\item \code{EastLongitudeDeg}: the eastern-most longitude expressed in degree, or
\code{NA} if the bounding box is unknown
\item \code{NorthLatitudeDeg}: the northern-most latitude expressed in degree, or
\code{NA} if the bounding box is unknown
}

\code{srs_get_axes_count()} returns the integer number of axes of the coordinate
system of the SRS. Wrapper of \code{OSRGetAxesCount()} in the GDAL API.

\code{srs_get_axes()} returns a named list of the axis names and their
orientations. Wrapper of \code{OSRGetAxis()} in the GDAL API.

\code{srs_epsg_treats_as_lat_long()} returns \code{TRUE} if this geographic coordinate
system should be treated as having latitude/longitude coordinate ordering.
Wrapper of \code{OSREPSGTreatsAsLatLong()} in the GDAL API.

\code{srs_epsg_treats_as_northing_easting()} returns \code{TRUE} if this geographic
coordinate system should be treated as having northing/easting coordinate
ordering. Wrapper of \code{OSREPSGTreatsAsNorthingEasting()} in the GDAL API.

\code{srs_get_celestial_body_name()} returns the name of the celestial body of
the SRS, e.g., \code{"Earth"} for an Earth SRS. Wrapper of
\code{OSRGetCelestialBodyName()} in the GDAL API. Requires GDAL >= 3.12 and
PROJ >= 8.1.
}
\examples{
wkt <- 'PROJCS["ETRS89 / UTM zone 32N (N-E)",
        GEOGCS["ETRS89",
            DATUM["European_Terrestrial_Reference_System_1989",
                SPHEROID["GRS 1980",6378137,298.257222101,
                    AUTHORITY["EPSG","7019"]],
                TOWGS84[0,0,0,0,0,0,0],
                AUTHORITY["EPSG","6258"]],
            PRIMEM["Greenwich",0,
                AUTHORITY["EPSG","8901"]],
            UNIT["degree",0.0174532925199433,
                AUTHORITY["EPSG","9122"]],
            AUTHORITY["EPSG","4258"]],
        PROJECTION["Transverse_Mercator"],
        PARAMETER["latitude_of_origin",0],
        PARAMETER["central_meridian",9],
        PARAMETER["scale_factor",0.9996],
        PARAMETER["false_easting",500000],
        PARAMETER["false_northing",0],
        UNIT["metre",1,
            AUTHORITY["EPSG","9001"]],
        AXIS["Northing",NORTH],
        AXIS["Easting",EAST]]'

srs_find_epsg(wkt)

srs_find_epsg(wkt, all_matches = TRUE)

srs_get_name("EPSG:5070")

srs_is_geographic("EPSG:5070")
srs_is_geographic("EPSG:4326")

srs_is_derived_gcs("WGS84")

srs_is_projected("EPSG:5070")
srs_is_projected("EPSG:4326")

srs_is_compound("EPSG:4326")

srs_is_geocentric("EPSG:7789")

srs_is_vertical("EPSG:5705")

srs_get_area_of_use("EPSG:3976")

srs_get_axes_count("EPSG:4326")
srs_get_axes_count("EPSG:4979")

# ordered list of axis names and their orientation
srs_get_axes("EPSG:4326+5773")

srs_epsg_treats_as_lat_long("WGS84")

# NAD83 / Conus Albers:
srs_epsg_treats_as_northing_easting("EPSG:5070")
# WGS 84 / UPS North (N,E):
srs_epsg_treats_as_northing_easting("EPSG:32661")
# WGS 84 / UPS South (N,E):
srs_epsg_treats_as_northing_easting("EPSG:32761")

## Requires GDAL >= 3.12 and PROJ >= 8.1
# srs_get_celestial_body_name("EPSG:4326")
#> [1] "Earth"
# srs_get_celestial_body_name("IAU_2015:30100")
#> [1] "Moon"

f <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, f)

ds$getProjection() |> srs_is_projected()
ds$getProjection() |> srs_get_utm_zone()
ds$getProjection() |> srs_get_angular_units()
ds$getProjection() |> srs_get_linear_units()
ds$getProjection() |> srs_get_axis_mapping_strategy()

ds$getProjection() |> srs_is_same("EPSG:26912")
ds$getProjection() |> srs_is_same("NAD83")

ds$close()

## Requires GDAL >= 3.4
if (gdal_version_num() >= gdal_compute_version(3, 4, 0)) {
  if (srs_is_dynamic("WGS84"))
    print("WGS84 is dynamic")

  if (!srs_is_dynamic("NAD83"))
    print("NAD83 is not dynamic")
}
}
\seealso{
\link{srs_convert}
}
