% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_range.R
\name{gc_range}
\alias{gc_range}
\title{Determine ORF Range for a Candidate Gene Cluster}
\usage{
gc_range(Norf_position = Norf_position, AllGeneNum = 20, MinConSeq = 10)
}
\arguments{
\item{Norf_position}{Numeric vector of ORF positions (ascending) that belong
to the current candidate cluster (output from
\code{\link{gc_position}}).}

\item{AllGeneNum}{Integer.  Maximum allowed genomic span (in ORF count) for
the final cluster.}

\item{MinConSeq}{Integer.  Minimum number of consecutive reference genes
required for the cluster.}
}
\value{
A numeric vector containing the \strong{final ORF positions} that define
the validated gene cluster.  If no valid block can be produced, the
vector will be empty.
}
\description{
Internal helper used by \code{\link{gc_cal}}.
After \code{\link{gc_position}} has isolated the ORF positions
belonging to a single cluster, this function \strong{validates} and
\strong{trims} that range so that the final span (distance between the
first and last retained ORF) does not exceed \code{AllGeneNum}.
The goal is to retain the \strong{largest contiguous block} that still
satisfies the user-defined size limit.
}
\details{
\itemize{
\item For every reference gene in \code{Norf_position}, the function evaluates
whether a window of at least \code{MinConSeq} consecutive reference genes
centred on that gene can fit within \code{AllGeneNum} consecutive ORFs.
\item Genes that pass the test are collected in \code{retain.site}.
\item The \strong{minimal} and \strong{maximal} positions in \code{retain.site} are then
used to slice the full ORF range, guaranteeing that the final cluster
length <= \code{AllGeneNum}.
}
}
