% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{abind}
\alias{abind}
\title{Combine generalized arrays}
\usage{
abind(..., margins = character(), along = character())
}
\arguments{
\item{...}{arrays, or a list of several arrays.  Margins of
these arrays should be the same.}

\item{margins}{Resulting margins.  If includes a totally new margin (not
used by any arrays in \code{...}), then
\code{along} is neglected and the new margin setting \code{along}.
If no new name and \code{length(along)==0L}, the last \code{margins} become along.
If \code{0L==length(margins)}, \code{along} will become last dimensions of output.}

\item{along}{The dimension along which to bind the arrays.
The arrays may have different lengths along that dimension,
and are bind along it, with addition subdimension '*.bind.from'
indicating the composition
of the \code{along} dimension.  Some arrays may not
have that margin, then the dimension of these arrays expand to 1.
If \code{along} is a totally new margin, it is created.
In such case, all arrays should have the same dimension.}
}
\description{
Combine generalized arrays, similar to the manner cbind and rbind work.
Put a sequence of generalized arrays and get a single generalized array
of the same or one more margins.
}
\details{
Combine sdim correctly.
Saving or dropping of subdimensions follow a few rules: subdimensions of
the margin with bound along are dropped; of the other margins are save
unless the names of subdimensions are the same; subdimensions of the
same names are dropped except the first one.
}
\examples{
a <- garray(1:24, c(4,6),
	dimnames=list(X=1:4, Y=letters[1:6]),
 	sdim=list(XX=c(x1=3,x2=1), YY=c(y1=1,y2=2)))
b <- garray(1:6/10,6,dimnames=list(Y=letters[1:6]))
ab <- abind(a=a, b=b, along="X")
#abind(a, b, margins=c("X","Y"))	# Error
ab2 <- abind(a=a, b=b, margins=c("X","Y"), along="X")
aa <- abind(a=a, a=a, along="Z")
ab3 <- abind(a, b, along="X")
}
