% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.galamm.R
\name{residuals.galamm}
\alias{residuals.galamm}
\title{Residuals of galamm objects}
\usage{
\method{residuals}{galamm}(object, type = c("pearson", "deviance"), scaled = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{type}{Character of length one describing the type of residuals to be
returned. One of \code{"pearson"} and \code{"deviance"}. Argument is case
sensitive.}

\item{scaled}{Logical value specifying whether to scale the residuals by
their standard deviation. Defaults to \code{FALSE}.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
Numeric vector of residual values.
}
\description{
Computes residuals for models fit with \code{\link[=galamm]{galamm()}} using the definitions in
Chapter 8 of \insertCite{dunnGeneralizedLinearModels2018;textual}{galamm}.
Define \eqn{y} as the response and \eqn{\hat{\mu}} as the model fit. Importantly,
\eqn{\hat{\mu}} includes all random effects. Also define \eqn{V(\cdot)} as the
variance function of the model family, and \eqn{w} as the weight. The Pearson
residual is then
\deqn{r_{P} = (y - \hat{\mu})/\sqrt{V(\hat{\mu}) / w}.}
Furthermore, let \eqn{sgn(\cdot)} be the function which returns the sign of its
argument and let \eqn{d(y, \hat{\mu})} be the model deviance. The deviance
residual is then
\deqn{r_{D} = sgn(y - \hat{\mu}) \sqrt{w d(y, \hat{\mu})}.}
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Extract residuals
residuals(count_mod)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=fitted.galamm]{fitted.galamm()}} for model fitted values, \code{\link[=predict.galamm]{predict.galamm()}} for
model predictions, and \code{\link[=plot.galamm]{plot.galamm()}} for diagnostic plots. The generic
function is \code{\link[=residuals]{residuals()}}.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{appraise.galamm}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{derivatives.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
