% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr-unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest a query}
\usage{
unnest(.query)
}
\arguments{
\item{.query}{An object of class \code{metadata_request}}
}
\value{
An object of class \code{metadata_request}
}
\description{
This syntax is borrowed from \code{tidyr}, and is conceptually used in the same
way here, but in galah unnest amends the query to unnest information
server-side, rather than on your machine. It powers all of the
\code{\link[=show_values]{show_values()}} functions in galah.
}
\details{
Re-implementing existing functions has the consequence of supporting
consistent syntax with tidyverse, at the cost of potentially introducing
conflicts. This can be avoided by using the \code{::} operator where required.
}
\examples{
\dontrun{
# Return values of field `basisOfRecord`
request_metadata() |> 
  unnest() |> 
  filter(field == basisOfRecord) |> 
  collect()
  
# Using `galah::unnest()` in this way is equivalent to:
show_all(fields, "basisOfRecord") |> 
  show_values()
  
# to add information to a species list:
request_metadata() |>
  filter(list == "dr650") |>
  select(everything()) |>
  unnest() |>
  collect()
}
}
