% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwqs.R
\name{gwqs_barplot}
\alias{gwqs_barplot}
\alias{gwqs_scatterplot}
\alias{gwqs_fitted_vs_resid}
\alias{gwqs_levels_scatterplot}
\alias{gwqs_ROC}
\alias{gwqs_boxplot}
\alias{gwqs_summary_tab}
\alias{gwqs_weights_tab}
\alias{selectdatavars}
\alias{gwqs_rank}
\title{Plots and tables functions}
\usage{
gwqs_barplot(object, tau, ...)

gwqs_scatterplot(object, ...)

gwqs_fitted_vs_resid(object, sumtype = c("norm", "perc"), ...)

gwqs_levels_scatterplot(object, ...)

gwqs_ROC(object, newdata, sumtype = c("norm", "perc"), ...)

gwqs_boxplot(object, tau, ...)

gwqs_summary_tab(object, sumtype = c("norm", "perc"), ...)

gwqs_weights_tab(object, ...)

selectdatavars(data, na.action, formula, mix_name, ...)

gwqs_rank(data, mix_name, q)
}
\arguments{
\item{object}{An object of class "gwqs" as returned by \link[gWQS]{gwqs}.}

\item{tau}{A number identifying the cutoff for the significant weights. Is tau is missing then reciprocal of
the number of elements in the mixture is considered. To avoid printing the threshold line set \code{tau = NULL}.}

\item{...}{Further arguments to be passed.}

\item{sumtype}{Type of summary statistic to be used: "norm" takes the mean of the estimated parameters on the
validation sets and the 95% CI assuming a normal distribution of the parameters, while "perc" uses the median
as the parameters estimates and the 2.5, 97.5 percentiles as CI. This option is only available for objects of
class \code{gwqsrh}.}

\item{newdata}{A data frame in which to look for variables with which to predict and generate the
ROC curve.}

\item{data}{Dataset from which you want to select the variables you are interested in.}

\item{na.action}{Allows to choose what action has to be taken to deal with NAs.}

\item{formula}{Formula used in the model to specify the dependent and independent variables.}

\item{mix_name}{Vector containing element names included in the mixture.}

\item{q}{An \code{integer} to specify how mixture variables will be ranked, e.g. in quartiles
(\code{q = 4}), deciles (\code{q = 10}), or percentiles (\code{q = 100}).}
}
\value{
All the plot functions print the output in the Plots pane while the table functions print
the output in the Viewer pane.

\item{Qm}{The matrix containing the quantiled variables of the elements included in the mixture.}
\item{qi}{A list of vectors containing the cut points used to determine the quantiled variables.}
}
\description{
Functions that allow to generate plots and tables helping in visualizing and summarise Weighted Quantile Sum (WQS) regression results.
}
\details{
The \code{gwqs_barplot}, \code{gwqs_scatterplot}, \code{gwqs_fitted_vs_resid}, \code{gwqs_levels_scatterplot},
\code{gwqs_ROC} and \code{gwqs_boxplot} functions produce five figures through the \code{\link[ggplot2]{ggplot}} function.

The \code{gwqs_summary_tab} and \code{gwqs_weights_tab} functions produce two tables in the viewr pane
through the use of the \code{\link[knitr]{kable}} and \code{\link[kableExtra]{kable_styling}} functions.

The \code{gwqs_barplot}, \code{gwqs_scatterplot} plots are available for all family types while
\code{gwqs_fitted_vs_resid} is not available when \code{family = binomial} or \code{"multinomial"}.
\code{gwqs_levels_scatterplot} plot is only available when \code{family = "multinomial"} and \code{gwqs_ROC}
when \code{family = binomial}. The \code{gwqs_boxplot} can be used when the parameter \code{rh} within
the \code{gwqs} function is set greater than 1.

The \code{gwqs_rank} function allows to split the variables selected through the vector \code{mix_name}
in quantiles (depending by the value assigned to \code{q}).
}
\examples{
toxic_chems = names(wqs_data)[1:34]
results = gwqs(yLBX ~ wqs, mix_name = toxic_chems, data = wqs_data, q = 4, validation = 0.6,
               b = 2, b1_pos = TRUE, b_constr = FALSE, family = gaussian)

# barplot
gwqs_barplot(results)

# scatterplot
gwqs_scatterplot(results)

# fitted values vs rediduals scatterplot
gwqs_fitted_vs_resid(results)

}
\author{
Stefano Renzetti, Paul Curtin, Allan C Just, Ghalib Bello, Chris Gennings
}
