% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_function.R
\name{estfun.gam}
\alias{estfun.gam}
\title{Estimating Robust/Clustered Standard Errors with \code{mgcv}}
\usage{
\method{estfun}{gam}(x, correct_df = TRUE, override_check = FALSE, ...)
}
\arguments{
\item{x}{A model estimated using \code{gam} or \code{bam}.}

\item{correct_df}{The default, \code{TRUE}, adjusts \code{sandwich} to use the
effective degrees of freedom for \code{k} instead of the number of columns
of the design. \code{FALSE} uses \code{k}.}

\item{override_check}{The default, \code{FALSE}, allows this function to be
used inside of \code{sandwich}. If only the matrix of scores is required,
set to \code{TRUE}.}

\item{...}{Not used for \code{estfun.gam}.}
}
\value{
A matrix used internally for \code{sandwich}.
}
\description{
This extracts the score of the log-likelihood for each observation for a
model estimated using \code{gam} or \code{bam}. It is necessary to allow
\code{mgcv} to work correctly with functions from \code{sandwich} to product
cluster or robust standard errors.
}
\keyword{internal}
