% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{ftry}
\alias{ftry}
\title{Wrap a try block in futile.logger}
\usage{
ftry(expr, error = stop, finally = NULL, silent = FALSE, details = "")
}
\arguments{
\item{expr}{The expression to evaluate in a try block}

\item{error}{An error handler}

\item{finally}{Pass-through to tryCatch finally}

\item{silent}{Boolean - should errors be rethrown? The same as the silent option on `try`.
If a custom error handler is being used that takes control over this option. Note you should
test the return value if you are dependent on it.}

\item{details}{An extra string to print when there's a warning message}
}
\description{
This function integrates futile.logger with the error and warning system
so problems can be caught both in the standard R warning system, while
also being emitted via futile.logger.
}
\examples{
\dontrun{
ftry(log("a")) # Logs the warning (but the warning still bubbles)

x <- 'a'
y <- 2 # Some ID associated with x value
ftry(log("a"), details=sprintf("y = \%s",y))

ftry(log(-1)) # Logs the error and rethrows it
}
ftry(log(-1),silent=TRUE) # logs the error and silently continues
}
\author{
Brian Lee Yung Rowe
}
\keyword{data}
