% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainLayer.R
\name{TrainLayer}
\alias{TrainLayer}
\title{TrainLayer Class}
\description{
This class implements a traning layer. A \link{TrainLayer} object can only exist as a component of a \link{Training} object.

A training layer is structured as followed:
\itemize{
\item \link{TrainData}: Data to be used to train the learner.
\item \link{Lrner}: Includes a learning function and the package implementing the function.
\item \link{Model}: The result of training the learner on the training data.
\item \link{VarSel}: Includes a variable selection function and the package implementing the function.
}

A training layer can train its learner on its training data and store the resulting model. See the public function \code{Layer$train()} below.

A training layer can make predictions for a new layer passed as argument to its predict function. See the public function \code{Layer$predict()} below.
}
\seealso{
\link{Training}, \link{Lrner}, \link{TrainData}, \link{TestData} and \link{Model}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{TrainLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrainLayer-new}{\code{TrainLayer$new()}}
\item \href{#method-TrainLayer-print}{\code{TrainLayer$print()}}
\item \href{#method-TrainLayer-getTraining}{\code{TrainLayer$getTraining()}}
\item \href{#method-TrainLayer-getTargetObj}{\code{TrainLayer$getTargetObj()}}
\item \href{#method-TrainLayer-train}{\code{TrainLayer$train()}}
\item \href{#method-TrainLayer-varSelection}{\code{TrainLayer$varSelection()}}
\item \href{#method-TrainLayer-predict}{\code{TrainLayer$predict()}}
\item \href{#method-TrainLayer-getTrainData}{\code{TrainLayer$getTrainData()}}
\item \href{#method-TrainLayer-getTargetValues}{\code{TrainLayer$getTargetValues()}}
\item \href{#method-TrainLayer-getIndIDs}{\code{TrainLayer$getIndIDs()}}
\item \href{#method-TrainLayer-getTestData}{\code{TrainLayer$getTestData()}}
\item \href{#method-TrainLayer-getLrner}{\code{TrainLayer$getLrner()}}
\item \href{#method-TrainLayer-getVarSel}{\code{TrainLayer$getVarSel()}}
\item \href{#method-TrainLayer-getModel}{\code{TrainLayer$getModel()}}
\item \href{#method-TrainLayer-checkLrnerExist}{\code{TrainLayer$checkLrnerExist()}}
\item \href{#method-TrainLayer-checkModelExist}{\code{TrainLayer$checkModelExist()}}
\item \href{#method-TrainLayer-checkVarSelExist}{\code{TrainLayer$checkVarSelExist()}}
\item \href{#method-TrainLayer-checkTrainDataExist}{\code{TrainLayer$checkTrainDataExist()}}
\item \href{#method-TrainLayer-summary}{\code{TrainLayer$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$new(id, training)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Training layer id.}

\item{\code{training}}{\code{Training}\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getTraining"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getTraining}{}}}
\subsection{Method \code{getTraining()}}{
Getter of the current training object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getTraining()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current training object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getTargetObj"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getTargetObj}{}}}
\subsection{Method \code{getTargetObj()}}{
Getter of the target object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getTargetObj()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-train"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-train}{}}}
\subsection{Method \code{train()}}{
Trains the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$train(ind_subset = NULL, use_var_sel = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
ID subset of individuals to be used for training.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, variable selection is performed before training.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current layer is returned with the resulting model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-varSelection"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-varSelection}{}}}
\subsection{Method \code{varSelection()}}{
Variable selection on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$varSelection(ind_subset = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
ID subset of individuals to be used for variable selection.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current layer is returned with the resulting model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-predict"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts values for the new layer taking as argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$predict(new_layer, use_var_sel, ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_layer}}{\code{TrainLayer} \cr}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, selected variables available at each layer are used.}

\item{\code{ind_subset}}{\code{vector} \cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \link{PredictLayer} object with the predicted data is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getTrainData"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getTrainData}{}}}
\subsection{Method \code{getTrainData()}}{
Getter of the training dataset stored on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getTrainData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{TrainData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getTargetValues"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getTargetValues}{}}}
\subsection{Method \code{getTargetValues()}}{
Getter of target values from the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getTargetValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs and corresponding target values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Getter of IDS from the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getTestData"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getTestData}{}}}
\subsection{Method \code{getTestData()}}{
Getter of the new data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getTestData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{TestData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getLrner"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getLrner}{}}}
\subsection{Method \code{getLrner()}}{
Getter of the learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getLrner()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{Lrner} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getVarSel"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getVarSel}{}}}
\subsection{Method \code{getVarSel()}}{
Getter of the variable selector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getVarSel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{VarSel} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-getModel"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-getModel}{}}}
\subsection{Method \code{getModel()}}{
Getter of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$getModel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{Model} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-checkLrnerExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-checkLrnerExist}{}}}
\subsection{Method \code{checkLrnerExist()}}{
Check whether a learner has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$checkLrnerExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-checkModelExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-checkModelExist}{}}}
\subsection{Method \code{checkModelExist()}}{
Check whether a model has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$checkModelExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-checkVarSelExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-checkVarSelExist}{}}}
\subsection{Method \code{checkVarSelExist()}}{
Check whether a variable selection tool has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$checkVarSelExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-checkTrainDataExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-checkTrainDataExist}{}}}
\subsection{Method \code{checkTrainDataExist()}}{
Check whether a training data has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$checkTrainDataExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainLayer-summary"></a>}}
\if{latex}{\out{\hypertarget{method-TrainLayer-summary}{}}}
\subsection{Method \code{summary()}}{
Generate summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainLayer$summary()}\if{html}{\out{</div>}}
}

}
}
