% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunRegPermutation.r
\name{funreg.permutation}
\alias{funreg.permutation}
\title{Do a permutation test for functional regression}
\usage{
funreg.permutation(object, num.permute = 500, seed = NULL)
}
\arguments{
\item{object}{An object of class funreg}

\item{num.permute}{The number of permutations to use.  Ramsay, Hooker and Graves (2009) 
recommended ``several hundred'' (p. 145), but for a quicker initial look
it might suffice to use 100.}

\item{seed}{An optional random number seed.}
}
\value{
Returns a list with several components. First, 
\code{pvalue.F} is the p-value for the F test.  Second, \code{conf.int.for.pvalue.F} is
the confidence interval for estimating the p-value that would
be obtained from the dataset as \code{num.permute} approached infinity. 
The idea of a confidence interval for a p-value is explained further by 
Sen (2013), with a STATA example. 
Third, \code{orig.F} is the F statistic calculated on the original
dataset. Last, \code{permuted.F} is the vector of F statistics calculated
on each of the random permuted datasets.  Also included are \code{pvalue.LR},
\code{conf.int.for.pvalue.LR},  \code{orig.LR}, \code{permuted.LR} for
the permutation test with a likelihood ratio statistic.
A more conservative alternative formula for the p-value is used in 
\code{pvalue.F.better} and \code{pvalue.LR.better}.  
It is not obvious whether to define the p-value as the 
proportion of permuted datasets with statistics less than or equal to
the original, or simply less than the original.  This should usually not 
matter, as a tie is not likely.  We made the arbitrary decision to use 
the former here because it was presented in this way in the 
Wikipedia article for permutation tests.                                     
The conservative alternative formula is 
the number of less extreme permuted datasets plus one,
over the total number of datasets plus one.  Adding one to the numerator
and denominator is suggested by some authors, partly  in order to prevent
a nonsensical zero p-value (Onghena & May, 1995; Phipson, Belinda & Smyth, 2010).
}
\description{
Performs a permutation F test (Ramsay, Hooker, and Graves, 2009, p. 145)
for the significance of a functional covariate, and a permutation
likelihood ratio test.  The permutation test function currently doesn't allow models
 with multiple functional covariates, but 
subject-level covariates are allowed.
}
\references{
Onghena, P., & May, R. B. (1995). Pitfalls in computing and interpreting
         randomization test p values: A commentary on Chen and Dunlap.
         Behavior Research Methods, Instruments, & Computers, 27(3), 408-411. DOI: 10.3758/BF03200438.

Phipson, Belinda and Smyth, Gordon K. (2010) Permutation P-values 
         Should Never Be Zero:  Calculating Exact P-values When Permutations
         Are Randomly Drawn.  Statistical Applications
        in Genetics and Molecular Biology: Vol. 9: Iss. 1, Article 39. DOI: 10.2202/1544-6115.1585.    

Ramsay, J. O., Hooker, G., & Graves, S. (2009). Functional
          data analysis with R and MATLAB. NY: Springer.

Sen, S. (2014) Permutation Tests.
}
