% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrictedness.R
\name{restrictedness}
\alias{restrictedness}
\title{Geographical Restrictedness on site-species matrix}
\usage{
restrictedness(pres_matrix, relative = FALSE)
}
\arguments{
\item{pres_matrix}{a site-species matrix, with species in rows and sites
in columns, containing presence-absence, relative abundances or
abundances values}

\item{relative}{a logical (default = FALSE), indicating if restrictedness
should be computed relative to restrictedness from a species occupying a
single site}
}
\value{
A stacked data.frame containing species' names and their
restrictedness value in the \strong{Ri} column, similar to what
\code{\link[=uniqueness]{uniqueness()}} returns.
}
\description{
Computes geographical restrictedness from a site-species matrix.
Geographical restrictedness is an index related to the extent of a species
in a given dataset, it is close to 1 when the species is present in only a
single site of the dataset (restricted) and close to 0 when the species is
present at all sites. It estimates the geographical extent of a species in a
dataset. See \code{Details} section to have details on the formula used for
the computation. The sites-species matrix should have \strong{sites}
in \strong{rows} and \strong{species} in \strong{columns}, similar to \pkg{vegan} package
defaults.
}
\details{
Geographical Restrictedness aims to measure the regional extent of a species
in \pkg{funrar} it is computed the simplest way possible: a ratio of the
number of sites where a species is present over the total number of sites in
the dataset. We take this ratio off 1 to have a index between 0 and 1 that
represents how restricted a species is:
\deqn{
 R_i = 1 - \frac{N_i}{N_tot},
}{
 R_i = 1 - (N_i/N_tot),
}
where \eqn{R_i} is the geographical restrictedness value, \eqn{N_i} the total
number of sites where species \eqn{i} occur and \eqn{N_tot} the total number
of sites in the dataset.
When \code{relative = TRUE}, restrictedness is computed relatively to the
restrictedness of a species present in a single site:
\deqn{
 R_i = \frac{R_i}{R_one}
}{
 R_i = R_i / R_one
}
\deqn{
 R_i = \frac{1 - \frac{K_i}{K_tot}}{1 - \frac{1}{K_tot}}
}{
 R_i = (1 - K_i/K_tot)(1 - 1/K_tot)
}
\deqn{
 R_i = \frac{K_tot - K_i}{K_tot - 1}
}{
 R_i = (K_tot - K_i)(K_tot - 1)
}
Other approaches can be used to measure the geographical extent
(convex hulls, occupancy models, etc.) but for the sake of simplicity only
the counting method is implemented in \pkg{funrar}.
}
\examples{
data("aravo", package = "ade4")
# Site-species matrix
mat = as.matrix(aravo$spe)
ri = restrictedness(mat)
head(ri)

}
