% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb.R
\name{wb}
\alias{wb}
\title{Wu & Browne model error method}
\usage{
wb(mod, target_rmsea, wb_mod = NULL, adjust_target = TRUE)
}
\arguments{
\item{mod}{A `fungible::simFA()` model object.}

\item{target_rmsea}{(scalar) Target RMSEA value.}

\item{wb_mod}{(`lm` object) An optional `lm` object used to find a target
RMSEA value that results in solutions with RMSEA values close to the
desired value. Note that if no `wb_mod` is provided, a model will be
estimated at run time. If many population correlation matrices are going to
be simulated using the same model, it will be considerably faster to
estimate `wb_mod` ahead of time. See also `get_wb_mod()`.}

\item{adjust_target}{(TRUE; logical) Should the target_rmsea value be
adjusted to ensure that solutions have RMSEA values that are close to the
provided target RMSEA value? Defaults to TRUE and should stay there unless
you have a compelling reason to change it.}
}
\description{
Generate a population correlation matrix using the model described in Wu and
Browne (2015).
}
\details{
The Wu and Browne method generates a correlation matrix with model
  error (\eqn{\Sigma}) using

  \deqn{(\Sigma | \Omega) ~ IW(m, m \Omega),}

  where \eqn{m ~= 1/\epsilon^2} is a precision parameter related to RMSEA
  (\eqn{\epsilon}) and \eqn{IW(m, m \Omega)} denotes an inverse Wishart
  distribution. Note that *there is no guarantee that the RMSEA will be very
  close to the target RMSEA*, particularly when the target RMSEA value is
  large. Based on experience, the method tends to give solutions with RMSEA
  values that are larger than the target RMSEA values. Therefore, it might be
  worth using a target RMSEA value that is somewhat lower than what is
  actually needed. Alternatively, the \code{\link{get_wb_mod}} function can
  be used to estimate a coefficient to shrink the target RMSEA value by an
  appropriate amount so that the solution RMSEA values are close to the
  (nominal) target values.
}
\examples{
# Specify a default model using simFA()
mod <- fungible::simFA(Seed = 42)

set.seed(42)
wb(mod, target_rmsea = 0.05)
}
\references{
Wu, H., & Browne, M. W. (2015). Quantifying adventitious error in
  a covariance structure as a random effect. *Psychometrika*, *80*(3),
  571–600. <https://doi.org/10/gjrkc4>
}
\author{
Justin Kracht <krach018@umn.edu>
}
