% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctionsStandard.R
\name{plot.simulate.fgpm}
\alias{plot.simulate.fgpm}
\title{Plot method for the simulations of a \code{fgpm} model}
\usage{
\method{plot}{simulate.fgpm}(x, y = NULL, detail = NA, ...)
}
\arguments{
\item{x}{An object with S3 class \code{simulate.fgpm} as created
by \link[funGp]{simulate,fgpm-method}.}

\item{y}{Not used.}

\item{detail}{An optional character string specifying the data
elements that should be included in the plot, to be chosen
between \code{"light"} and \code{"full"}. A \emph{light} plot
will include only the simulated values, while a
\emph{full} plot will also include the predicted mean and
confidence bands at the simulation points. This argument will
only be used if full simulations (including the mean and
confidence bands) are provided, otherwise it will be
ignored. See \link[funGp]{simulate,fgpm-method} for more details on the
generation of light and full simulations.}

\item{...}{Additional arguments affecting the display. The
following typical graphics parameters are valid entries:
\emph{xlim}, \emph{ylim}, \emph{xlab}, \emph{ylab},
\emph{main}. The boolean argument \emph{legends} can also be
included in any of the two lists in order to control the
display of legends in the corresponding plot.}
}
\description{
This method displays the simulated output values
    delivered by a funGp Gaussian process model.
}
\examples{
# plotting light simulations________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0, 1, length = sqrt(n.tr)),
                   x2 = seq(0, 1, length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr * 10), ncol = 10),
            f2 = matrix(runif(n.tr * 22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# making light simulations
n.sm <- 100
sIn.sm <- as.matrix(expand.grid(x1 = seq(0, 1, length = sqrt(n.sm)),
                                x2 = seq(0, 1, length = sqrt(n.sm))))
fIn.sm <- list(f1 = matrix(runif(n.sm * 10), ncol = 10),
               f2 = matrix(runif(n.sm * 22), ncol = 22))
simsl <- simulate(m1, nsim = 10, sIn.sm = sIn.sm, fIn.sm = fIn.sm)

# plotting light simulations
plot(simsl)


# plotting full simulations_________________________________________________
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0, 1, length = sqrt(n.tr)),
                   x2 = seq(0, 1, length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr * 10), ncol = 10),
            f2 = matrix(runif(n.tr * 22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# making full simulations
n.sm <- 100
sIn.sm <- as.matrix(expand.grid(x1 = seq(0, 1, length = sqrt(n.sm)),
                                x2 = seq(0, 1 ,length = sqrt(n.sm))))
fIn.sm <- list(f1 = matrix(runif(n.sm * 10), ncol = 10),
               f2 = matrix(runif(n.sm * 22), ncol = 22))
simsf <- simulate(m1, nsim = 10, sIn.sm = sIn.sm, fIn.sm = fIn.sm,
                  detail = "full")

# plotting full simulations in "full" mode
plot(simsf)

# plotting full simulations in "light" mode
plot(simsf, detail = "light")

}
\seealso{
\strong{*} \link[funGp]{fgpm} for the construction of funGp models;

\strong{*} \link[funGp]{plot,fgpm-method} for model diagnostic plots;

\strong{*} \link[funGp]{predict,fgpm-method} for predictions based on a funGp model;

\strong{*} \link[funGp]{plot.predict.fgpm} for prediction plots.
}
\author{
José Betancourt, François Bachoc and Thierry Klein
}
