% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjointTrKS.R
\name{conjointTriadKS}
\alias{conjointTriadKS}
\title{k-Spaced Conjoint Triad (conjointTriadKS)}
\usage{
conjointTriadKS(seqs, rng = 3, upto = FALSE, normalized = FALSE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{rng}{This parameter can be a number or a vector. Each element of the vector shows the number of spaces between the first and the second amino acids
and the second and the third amino acids of the tripeptide.
For each k in the rng vector, a new vector (whose size is 7^3) is created which contains the frequency of tri-amino acid with k gaps.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from 0 to rng.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (7^3)*(length rng vector).
}
\description{
This function calculates the grouped tripeptide composition with conjoint
triad grouping type. For each k, it creates a 7^3 feature vector.
K is the space between the first and the second amino acids
and the second and the third amino acids of the tripeptide.
}
\details{
A tripeptide with k spaces looks like AA1(ss..s)AA2(ss..s)AA3. AA stands for amino acids and s means space.
}
\note{
'upto' is enabled only when rng is a number and not a vector.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-conjointTriadKS(filePrs,rng=2,upto=TRUE,normalized=TRUE)

mat2<-conjointTriadKS(filePrs,rng=c(1,3,5))

}
