% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseKRAAC_T14.R
\name{PseKRAAC_T14}
\alias{PseKRAAC_T14}
\title{Pseudo K_tuple Reduced Amino Acid Composition Type-14 (PseKRAAC_T14)}
\usage{
PseKRAAC_T14(
  seqs,
  type = "gap",
  Grp = 2,
  GapOrLambdaValue = 2,
  k = 4,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{type}{This parameter has two valid value "lambda" and "gap". "lambda"
calls lambda_model function and "gap" calls gap_model function.}

\item{Grp}{is a numeric value. It shows the id of an amino acid group.
Please find the available groups in the detail section.}

\item{GapOrLambdaValue}{is an integer.
If type is gap, this value shows number of gaps between two k-mers.
If type is lambda, the value of GapOrLambdaValue shows the number of gaps between each two amino acids of k-mers.}

\item{k}{This parameter keeps the value of k in k-mer.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (Grp)^k.
}
\description{
There are 16 types of PseKRAAC function.
In the functions, a (user-selected) grouping of the amino acids might be used to reduce the amino acid alphabet.
Also, the functions have a type parameter.
The parameter determines the protein sequence analyses which can be either gap or lambda-correlation.
PseKRAAC_type14(PseKRAAC_T14) contains Grp 2-20.
}
\details{
Groups:
2=c('ARNDCQEGHKPST', 'ILMFWYV'),
3=c('ARNDQEGHKPST', 'C', 'ILMFWYV'),
4=c('ARNDQEGHKPST', 'C', 'ILMFYV', 'W'),
5=c('AGPST', 'RNDQEHK', 'C', 'ILMFYV', 'W'),
6=c('AGPST', 'RNDQEK', 'C', 'H', 'ILMFYV', 'W'),
7=c('ANDGST', 'RQEK', 'C', 'H', 'ILMFYV', 'P', 'W'),
8=c('ANDGST', 'RQEK', 'C', 'H', 'ILMV', 'FY', 'P', 'W'),
9=c('AGST', 'RQEK', 'ND', 'C', 'H', 'ILMV', 'FY', 'P', 'W'),
10=c('AGST', 'RK', 'ND', 'C', 'QE', 'H', 'ILMV', 'FY', 'P', 'W'),
11=c('AST', 'RK', 'ND', 'C', 'QE', 'G', 'H', 'ILMV', 'FY', 'P', 'W'),
12=c('AST', 'RK', 'ND', 'C', 'QE', 'G', 'H', 'IV', 'LM', 'FY', 'P', 'W'),
13=c('AST', 'RK', 'N', 'D', 'C', 'QE', 'G', 'H', 'IV', 'LM', 'FY', 'P', 'W'),
14=c('AST', 'RK', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'LM', 'FY', 'P', 'W'),
15=c('A', 'RK', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'LM', 'FY', 'P', 'ST', 'W'),
16=c('A', 'RK', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'LM', 'F', 'P', 'ST', 'W', 'Y'),
17=c('A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'LM', 'K', 'F', 'P', 'ST', 'W', 'Y'),
18=c('A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'LM', 'K', 'F', 'P', 'S', 'T', 'W', 'Y'),
19=c('A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'IV', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y'),
20=c('A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'V', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y')
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-PseKRAAC_T14(seqs=filePrs,type="gap",Grp=4,GapOrLambdaValue=3,k=2)

mat2<-PseKRAAC_T14(seqs=filePrs,type="lambda",Grp=4,GapOrLambdaValue=3,k=2)
}
\references{
Zuo, Yongchun, et al. "PseKRAAC: a flexible web server for generating pseudo K-tuple reduced amino acids composition." Bioinformatics 33.1 (2017): 122-124.
}
